/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.resolver;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.fabric3.binding.ws.metro.generator.WsdlElement;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolutionException;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolver;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.wsdl.factory.Wsdl4JFactory;
import org.oasisopen.sca.annotation.Reference;

public class EndpointResolverImpl
implements EndpointResolver {
    private static final QName SOAP11_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final QName SOAP12_ADDRESS_OLD = new QName("http://www.w3.org/2003/05/soap/bindings/HTTP/", "address");
    private static final QName SOAP12_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
    private Wsdl4JFactory wsdlFactory;

    public EndpointResolverImpl(@Reference Wsdl4JFactory wsdlFactory) {
        this.wsdlFactory = wsdlFactory;
    }

    public ServiceEndpointDefinition resolveServiceEndpoint(WsdlElement wsdlElement, Definition definition) throws EndpointResolutionException {
        return this.resolveServiceEndpoint(wsdlElement, definition, null);
    }

    public ServiceEndpointDefinition resolveServiceEndpoint(WsdlElement wsdlElement, Definition wsdl, URI uri) throws EndpointResolutionException {
        URI servicePath;
        QName serviceName = wsdlElement.getServiceName();
        QName portName = wsdlElement.getPortName();
        Port port = this.resolvePort(serviceName, portName, wsdl);
        if (uri == null) {
            URL url = this.getAddress(port);
            servicePath = URI.create(url.getPath());
        } else {
            servicePath = uri;
        }
        return new ServiceEndpointDefinition(serviceName, portName, servicePath);
    }

    public ReferenceEndpointDefinition resolveReferenceEndpoint(WsdlElement wsdlElement, Definition wsdl) throws EndpointResolutionException {
        try {
            QName serviceName = wsdlElement.getServiceName();
            QName portName = wsdlElement.getPortName();
            Port port = this.resolvePort(serviceName, portName, wsdl);
            URL url = this.getAddress(port);
            QName portTypeName = port.getBinding().getPortType().getQName();
            String serializedWsdl = this.serializeToString(wsdl);
            return new ReferenceEndpointDefinition(serviceName, false, portName, portTypeName, url, serializedWsdl);
        }
        catch (GenerationException e) {
            throw new EndpointResolutionException(e);
        }
    }

    private Port resolvePort(QName serviceName, QName portName, Definition wsdl) throws EndpointResolutionException {
        Service service = wsdl.getService(serviceName);
        if (service == null) {
            throw new EndpointResolutionException("WSDL service not found: " + serviceName);
        }
        Port port = service.getPort(portName.getLocalPart());
        if (port == null) {
            throw new EndpointResolutionException("WSDL port not found: " + portName);
        }
        return port;
    }

    private URL getAddress(Port port) throws EndpointResolutionException {
        for (Object o : port.getExtensibilityElements()) {
            ExtensibilityElement element = (ExtensibilityElement)o;
            QName elementType = element.getElementType();
            if (!SOAP11_ADDRESS.equals(elementType) && !SOAP12_ADDRESS.equals(elementType) && !SOAP12_ADDRESS_OLD.equals(elementType)) continue;
            try {
                Method m = element.getClass().getMethod("getLocationURI", new Class[0]);
                String locationURI = (String)m.invoke((Object)element, new Object[0]);
                return new URL(locationURI);
            }
            catch (MalformedURLException e) {
                throw new EndpointResolutionException("Invalid URL specified for port " + port.getName(), e);
            }
            catch (Exception e) {
                throw new EndpointResolutionException("Unable to resolve address for port " + port.getName(), e);
            }
        }
        throw new EndpointResolutionException("SOAP address not found on port " + port.getName());
    }

    private String serializeToString(Definition wsdl) throws GenerationException {
        try {
            WSDLWriter writer = this.wsdlFactory.newWriter();
            StringWriter stringWriter = new StringWriter();
            writer.writeWSDL(wsdl, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (WSDLException e) {
            throw new GenerationException((Throwable)e);
        }
    }
}

