/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.spi.objectfactory.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetroBindingProviderFactory<T>
implements ObjectFactory<T> {
    private SecurityConfiguration securityConfig;
    private ConnectionConfiguration connectionConfig;
    private List<Handler> handlers;

    public AbstractMetroBindingProviderFactory(SecurityConfiguration securityConfig, ConnectionConfiguration connConfig, List<Handler> handlers) {
        this.securityConfig = securityConfig;
        this.connectionConfig = connConfig;
        this.handlers = handlers;
    }

    protected void configureSecurity(BindingProvider provider) {
        if (this.securityConfig == null) {
            return;
        }
        Map context = provider.getRequestContext();
        if (this.securityConfig.getUsername() != null) {
            context.put("f3.username", this.securityConfig.getUsername());
            context.put("f3.password", this.securityConfig.getPassword());
        } else if (this.securityConfig.getAlias() != null) {
            context.put("f3.keystore.alias", this.securityConfig.getAlias());
        }
    }

    protected void configureConnection(BindingProvider provider) {
        if (this.connectionConfig == null) {
            return;
        }
        Map context = provider.getRequestContext();
        if (this.connectionConfig.getConnectTimeout() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.connect.timeout", this.connectionConfig.getConnectTimeout());
        }
        if (this.connectionConfig.getRequestTimeout() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.request.timeout", this.connectionConfig.getRequestTimeout());
        }
        if (this.connectionConfig.getClientStreamingChunkSize() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", this.connectionConfig.getClientStreamingChunkSize());
        }
    }

    protected void configureHandlers(BindingProvider provider) {
        if (this.handlers == null) {
            return;
        }
        String endpointPath = (String)provider.getRequestContext().get("javax.xml.ws.service.endpoint.address");
        if (endpointPath == null) {
            return;
        }
        provider.getBinding().setHandlerChain(this.handlers);
    }
}

