/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.wss.SecurityEnvironment;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.ws.metro.MetroBindingMonitor;
import org.fabric3.binding.ws.metro.runtime.core.EndpointConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.EndpointException;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.MetroServlet;
import org.fabric3.spi.host.ServletHost;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

public class EndpointServiceImpl
implements EndpointService {
    private SecurityEnvironment securityEnvironment;
    private ExecutorService executorService;
    private ServletHost servletHost;
    private MetroBindingMonitor monitor;
    private MetroServlet metroServlet;

    public EndpointServiceImpl(@Reference SecurityEnvironment securityEnvironment, @Reference ExecutorService executorService, @Reference ServletHost servletHost, @Monitor MetroBindingMonitor monitor) {
        this.securityEnvironment = securityEnvironment;
        this.executorService = executorService;
        this.monitor = monitor;
        this.servletHost = servletHost;
    }

    @Init
    public void init() {
        this.metroServlet = new MetroServlet(this.executorService, this.securityEnvironment);
    }

    public void registerService(EndpointConfiguration configuration) throws EndpointException {
        String servicePath = configuration.getServicePath();
        if (this.servletHost.isMappingRegistered(servicePath)) {
            this.unregisterService(servicePath);
        }
        this.servletHost.registerMapping(servicePath, (Servlet)this.metroServlet);
        this.servletHost.registerMapping(servicePath + "/mex", (Servlet)this.metroServlet);
        this.metroServlet.registerService(configuration);
        this.monitor.endpointProvisioned(servicePath);
    }

    public void unregisterService(String path) {
        this.servletHost.unregisterMapping(path);
        this.servletHost.unregisterMapping(path + "/mex");
        this.metroServlet.unregisterService(path);
        this.monitor.endpointRemoved(path);
    }
}

