/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.fabric3.binding.ws.metro.runtime.core.AbstractMetroTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.core.InterceptorMonitor;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.objectfactory.ObjectCreationException;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroJavaTargetInterceptor
extends AbstractMetroTargetInterceptor {
    private ObjectFactory<?> proxyFactory;
    private Method method;
    private boolean oneWay;
    private int retries = 0;
    private InterceptorMonitor monitor;

    public MetroJavaTargetInterceptor(ObjectFactory<?> proxyFactory, Method method, boolean oneWay, int retries, InterceptorMonitor monitor) {
        this.proxyFactory = proxyFactory;
        this.method = method;
        this.oneWay = oneWay;
        this.retries = retries;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        Object[] payload = (Object[])msg.getBody();
        Object proxy = this.createProxy();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Message message = this.invokeRetry(payload, proxy);
            return message;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Message invokeRetry(Object[] payload, Object proxy) {
        int retry = 0;
        while (true) {
            try {
                if (this.oneWay) {
                    this.method.invoke(proxy, payload);
                    return NULL_RESPONSE;
                }
                Object ret = this.method.invoke(proxy, payload);
                return new MessageImpl(ret, false, null);
            }
            catch (WebServiceException e) {
                if (e.getCause() instanceof SocketTimeoutException) {
                    if (retry > this.retries) {
                        throw new ServiceUnavailableException((Throwable)e);
                    }
                    this.monitor.serviceUnavailableRetry(e);
                    ++retry;
                    continue;
                }
                throw new ServiceRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof WebServiceException && !(e.getTargetException() instanceof SOAPFaultException)) {
                    WebServiceException wse = (WebServiceException)e.getTargetException();
                    if (wse.getCause() instanceof SocketTimeoutException) {
                        if (retry >= this.retries) {
                            throw new ServiceUnavailableException((Throwable)e);
                        }
                        this.monitor.serviceUnavailableRetry(wse.getCause());
                        ++retry;
                        continue;
                    }
                    throw new ServiceRuntimeException((Throwable)e);
                }
                return new MessageImpl((Object)e.getTargetException(), true, null);
            }
            break;
        }
    }

    private Object createProxy() {
        try {
            return this.proxyFactory.getInstance();
        }
        catch (ObjectCreationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

