/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.mex.server.MEXEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.WSServlet;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import com.sun.xml.wss.SecurityEnvironment;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.runtime.core.EndpointConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.F3Container;
import org.fabric3.binding.ws.metro.runtime.core.F3Provider;
import org.fabric3.binding.ws.metro.runtime.core.F3ServletDelegate;
import org.fabric3.binding.ws.metro.runtime.core.ServletAdapterFactory;
import org.fabric3.binding.ws.metro.runtime.core.WsitConfigurationContainer;

public class MetroServlet
extends WSServlet {
    private static final long serialVersionUID = -2581439830158433922L;
    private static final String MEX_SUFFIX = "/mex";
    private ExecutorService executorService;
    private SecurityEnvironment securityEnvironment;
    private List<EndpointConfiguration> configurations = new ArrayList<EndpointConfiguration>();
    private ServletAdapterFactory servletAdapterFactory = new ServletAdapterFactory();
    private volatile F3ServletDelegate delegate;
    private F3Container container;
    private WSEndpoint<?> mexEndpoint;

    public MetroServlet(ExecutorService executorService, SecurityEnvironment securityEnvironment) {
        this.executorService = executorService;
        this.securityEnvironment = securityEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        if (this.delegate != null) {
            return;
        }
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader seiClassLoader = MEXEndpoint.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(seiClassLoader);
            this.container = new F3Container(servletContext, this.securityEnvironment);
            BindingImpl binding = BindingImpl.create((BindingID)BindingID.SOAP12_HTTP);
            this.mexEndpoint = WSEndpoint.create(MEXEndpoint.class, (boolean)false, null, null, null, (Container)this.container, (WSBinding)binding, null, null, null, (boolean)true);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        for (EndpointConfiguration configuration : this.configurations) {
            this.registerService(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerService(EndpointConfiguration configuration) {
        if (this.delegate == null) {
            this.configurations.add(configuration);
            return;
        }
        Class<?> seiClass = configuration.getSeiClass();
        ClassLoader classLoader = seiClass.getClassLoader();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            URL wsdlLocation = configuration.getWsdlLocation();
            SDDocumentSource primaryWsdl = null;
            if (wsdlLocation != null) {
                primaryWsdl = SDDocumentSource.create((URL)wsdlLocation);
            }
            BindingID bindingId = configuration.getBindingId();
            WebServiceFeature[] features = configuration.getFeatures();
            BindingImpl binding = BindingImpl.create((BindingID)bindingId, (WebServiceFeature[])features);
            Container endpointContainer = this.container;
            ArrayList<SDDocumentSource> metadata = null;
            URL generatedWsdl = configuration.getGeneratedWsdl();
            if (generatedWsdl != null) {
                endpointContainer = new WsitConfigurationContainer(this.container, generatedWsdl);
                metadata = new ArrayList<SDDocumentSource>();
                List<URL> schemas = configuration.getGeneratedSchemas();
                if (schemas != null) {
                    for (URL schema : schemas) {
                        metadata.add(SDDocumentSource.create((URL)schema));
                    }
                }
            }
            String servicePath = configuration.getServicePath();
            Invoker invoker = configuration.getInvoker();
            QName serviceName = configuration.getServiceName();
            QName portName = configuration.getPortName();
            this.loadHandlers((Binding)binding, configuration);
            WSEndpoint wsEndpoint = WSEndpoint.create(seiClass, (boolean)false, (Invoker)invoker, (QName)serviceName, (QName)portName, (Container)endpointContainer, (WSBinding)binding, (SDDocumentSource)primaryWsdl, metadata, null, (boolean)true);
            wsEndpoint.setExecutor((Executor)this.executorService);
            ServletAdapter adapter = (ServletAdapter)this.servletAdapterFactory.createAdapter(servicePath, servicePath, wsEndpoint);
            this.delegate.registerServletAdapter(adapter, F3Provider.class.getClassLoader());
            String mexPath = servicePath + MEX_SUFFIX;
            ServletAdapter mexAdapter = (ServletAdapter)this.servletAdapterFactory.createAdapter(mexPath, mexPath, this.mexEndpoint);
            this.delegate.registerServletAdapter(mexAdapter, F3Provider.class.getClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void unregisterService(String path) {
        if (this.delegate == null) {
            Iterator<EndpointConfiguration> it = this.configurations.iterator();
            while (it.hasNext()) {
                EndpointConfiguration configuration = it.next();
                if (!configuration.getServicePath().equals(path)) continue;
                it.remove();
                return;
            }
            return;
        }
        ServletAdapter adapter = this.delegate.unregisterServletAdapter(path);
        if (adapter != null) {
            this.container.removeEndpoint((BoundEndpoint)adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WSServletDelegate getDelegate(ServletConfig servletConfig) {
        if (this.delegate == null) {
            MetroServlet metroServlet = this;
            synchronized (metroServlet) {
                if (this.delegate == null) {
                    this.delegate = new F3ServletDelegate(servletConfig.getServletContext());
                }
            }
        }
        return this.delegate;
    }

    private void loadHandlers(Binding binding, EndpointConfiguration config) {
        List<Handler> handlers = config.getHandlers();
        if (handlers == null) {
            return;
        }
        binding.setHandlerChain(handlers);
    }
}

