/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.policy;

import com.sun.xml.ws.developer.BindingTypeFeature;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.binding.ws.metro.util.MayProvideIntents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureResolver
implements FeatureResolver {
    private Field field;

    public DefaultFeatureResolver() {
        try {
            this.field = WebServiceFeature.class.getDeclaredField("enabled");
            this.field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public WebServiceFeature[] getFeatures(List<QName> requestedIntents) {
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (requestedIntents.contains(MayProvideIntents.MESSAGE_OPTIMIZATION)) {
            features.add((WebServiceFeature)new MTOMFeature());
        }
        this.resolveBinding(requestedIntents, features);
        features.add((WebServiceFeature)new AddressingFeature());
        WebServiceFeature[] webServiceFeatures = new WebServiceFeature[features.size()];
        webServiceFeatures = features.toArray(webServiceFeatures);
        return webServiceFeatures;
    }

    private void resolveBinding(List<QName> requestedIntents, List<WebServiceFeature> features) {
        if (requestedIntents.contains(MayProvideIntents.SOAP1_1)) {
            features.add((WebServiceFeature)this.createBindingFeature("http://schemas.xmlsoap.org/wsdl/soap/http"));
        } else if (requestedIntents.contains(MayProvideIntents.SOAP1_2)) {
            features.add((WebServiceFeature)this.createBindingFeature("http://www.w3.org/2003/05/soap/bindings/HTTP/"));
        } else if (requestedIntents.contains(MayProvideIntents.X_SOAP1_2)) {
            features.add((WebServiceFeature)this.createBindingFeature("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/"));
        } else if (requestedIntents.contains(MayProvideIntents.REST)) {
            features.add((WebServiceFeature)this.createBindingFeature("http://jax-ws.dev.java.net/rest"));
        }
    }

    private BindingTypeFeature createBindingFeature(String bindingQName) {
        BindingTypeFeature feature = new BindingTypeFeature(bindingQName);
        try {
            this.field.set(feature, true);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return feature;
    }
}

