/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.contribution.ContributionLoadException;
import org.fabric3.contribution.ContributionLoader;
import org.fabric3.contribution.ContributionLoaderMonitor;
import org.fabric3.contribution.manifest.ContributionExport;
import org.fabric3.contribution.manifest.ContributionImport;
import org.fabric3.host.Names;
import org.fabric3.host.contribution.ContributionInUseException;
import org.fabric3.host.contribution.UnresolvedImportException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.builder.classloader.ClassLoaderWireBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.fabric3.spi.generator.ClassLoaderWireGenerator;
import org.fabric3.spi.model.physical.PhysicalClassLoaderWireDefinition;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionLoaderImpl
implements ContributionLoader {
    private final ContributionImport hostImport;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final MetaDataStore store;
    private final ClasspathProcessorRegistry classpathProcessorRegistry;
    private boolean classloaderIsolation;
    private Map<Class<? extends ContributionWire<?, ?>>, ClassLoaderWireGenerator<?>> generators;
    private ClassLoaderWireBuilder builder;
    private Field sysPathsField;

    public ContributionLoaderImpl(@Reference ClassLoaderRegistry classLoaderRegistry, @Reference MetaDataStore store, @Reference ClasspathProcessorRegistry classpathProcessorRegistry, @Reference Map<Class<? extends ContributionWire<?, ?>>, ClassLoaderWireGenerator<?>> generators, @Reference ClassLoaderWireBuilder builder, @Reference HostInfo info, @Monitor ContributionLoaderMonitor monitor) {
        this.classLoaderRegistry = classLoaderRegistry;
        this.store = store;
        this.classpathProcessorRegistry = classpathProcessorRegistry;
        this.generators = generators;
        this.builder = builder;
        this.classloaderIsolation = info.supportsClassLoaderIsolation();
        this.hostImport = new ContributionImport(Names.HOST_CONTRIBUTION);
        ContributionExport hostExport = new ContributionExport(Names.HOST_CONTRIBUTION);
        hostExport.resolve();
        this.hostImport.addResolved(Names.HOST_CONTRIBUTION, hostExport);
        try {
            this.sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            this.sysPathsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            monitor.nativeLibrariesNotSupported();
        }
    }

    @Override
    public ClassLoader load(Contribution contribution) throws ContributionLoadException, UnresolvedImportException {
        URI contributionUri = contribution.getUri();
        ClassLoader hostClassLoader = this.classLoaderRegistry.getClassLoader(Names.HOST_CONTRIBUTION);
        ContributionManifest manifest = contribution.getManifest();
        manifest.addImport((Import)this.hostImport);
        List<ContributionWire<?, ?>> wires = this.resolveImports(contribution);
        if (!this.classloaderIsolation) {
            return hostClassLoader;
        }
        MultiParentClassLoader loader = new MultiParentClassLoader(contributionUri, hostClassLoader);
        URL location = contribution.getLocation();
        if (location != null) {
            try {
                List classpath = this.classpathProcessorRegistry.process(location, manifest.getLibraries());
                for (URL url : classpath) {
                    loader.addURL(url);
                }
                this.setSysPathsField(loader);
            }
            catch (IOException e) {
                throw new ContributionLoadException(e);
            }
        }
        for (ContributionWire<?, ?> wire : wires) {
            ClassLoaderWireGenerator<?> generator = this.generators.get(wire.getClass());
            if (generator == null) continue;
            PhysicalClassLoaderWireDefinition wireDefinition = generator.generate(wire);
            this.builder.build(loader, wireDefinition);
        }
        List<URI> extenders = this.resolveExtensionProviders(contribution);
        for (URI uri : extenders) {
            ClassLoader cl = this.classLoaderRegistry.getClassLoader(uri);
            if (cl == null) continue;
            if (!(cl instanceof MultiParentClassLoader)) {
                throw new AssertionError((Object)("Extension point provider classloader must be a " + MultiParentClassLoader.class.getName()));
            }
            loader.addExtensionClassLoader((MultiParentClassLoader)cl);
        }
        List<URI> extensionPoints = this.resolveExtensionPoints(contribution);
        for (URI uri : extensionPoints) {
            ClassLoader cl = this.classLoaderRegistry.getClassLoader(uri);
            if (cl == null) continue;
            if (!(cl instanceof MultiParentClassLoader)) {
                throw new AssertionError((Object)("Extension point classloader must be a " + MultiParentClassLoader.class.getName()));
            }
            ((MultiParentClassLoader)cl).addExtensionClassLoader(loader);
        }
        this.classLoaderRegistry.register(contributionUri, (ClassLoader)loader);
        return loader;
    }

    @Override
    public void unload(Contribution contribution) throws ContributionInUseException {
        URI uri = contribution.getUri();
        Set contributions = this.store.resolveDependentContributions(uri);
        if (!contributions.isEmpty()) {
            HashSet<URI> dependents = new HashSet<URI>(contributions.size());
            for (Contribution dependent : contributions) {
                if (ContributionState.INSTALLED != dependent.getState()) continue;
                dependents.add(dependent.getUri());
            }
            if (!dependents.isEmpty()) {
                throw new ContributionInUseException("Contribution is in use: " + uri, uri, dependents);
            }
        }
        this.classLoaderRegistry.unregister(uri);
    }

    private List<ContributionWire<?, ?>> resolveImports(Contribution contribution) throws UnresolvedImportException {
        contribution.getWires().clear();
        ArrayList resolved = new ArrayList();
        ContributionManifest manifest = contribution.getManifest();
        for (Import imprt : manifest.getImports()) {
            URI uri = contribution.getUri();
            try {
                List wires = this.store.resolveContributionWires(uri, imprt);
                for (ContributionWire wire : wires) {
                    contribution.addWire(wire);
                    resolved.add(wire);
                }
            }
            catch (UnresolvedImportException e) {
                if (!imprt.isRequired()) continue;
                throw e;
            }
        }
        return resolved;
    }

    private List<URI> resolveExtensionProviders(Contribution contribution) {
        ArrayList<URI> uris = new ArrayList<URI>();
        ContributionManifest manifest = contribution.getManifest();
        for (String extensionPoint : manifest.getExtensionPoints()) {
            List providers = this.store.resolveExtensionProviders(extensionPoint);
            for (Contribution provider : providers) {
                uris.add(provider.getUri());
                contribution.addResolvedExtensionProvider(provider.getUri());
            }
        }
        return uris;
    }

    private List<URI> resolveExtensionPoints(Contribution contribution) {
        ArrayList<URI> uris = new ArrayList<URI>();
        ContributionManifest manifest = contribution.getManifest();
        for (String extend : manifest.getExtends()) {
            List extensionPoints = this.store.resolveExtensionPoints(extend);
            for (Contribution extensionPoint : extensionPoints) {
                uris.add(extensionPoint.getUri());
                extensionPoint.addResolvedExtensionProvider(contribution.getUri());
            }
        }
        return uris;
    }

    private void setSysPathsField(MultiParentClassLoader loader) {
        if (this.sysPathsField == null) {
            return;
        }
        try {
            this.sysPathsField.set(loader, null);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

