/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.contribution.ContributionLoader;
import org.fabric3.contribution.ContributionServiceMonitor;
import org.fabric3.contribution.InvalidDeployable;
import org.fabric3.host.contribution.ArtifactValidationFailure;
import org.fabric3.host.contribution.ContributionAlreadyInstalledException;
import org.fabric3.host.contribution.ContributionLockedException;
import org.fabric3.host.contribution.ContributionNotFoundException;
import org.fabric3.host.contribution.ContributionOrder;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.contribution.DuplicateContributionException;
import org.fabric3.host.contribution.DuplicateProfileException;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.RemoveException;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.contribution.UninstallException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.repository.Repository;
import org.fabric3.host.repository.RepositoryException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.ContentTypeResolutionException;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.DependencyException;
import org.fabric3.spi.contribution.DependencyResolver;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.validation.InvalidContributionException;
import org.fabric3.spi.introspection.validation.ValidationUtils;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ContributionServiceImpl
implements ContributionService {
    private ProcessorRegistry processorRegistry;
    private Repository repository;
    private MetaDataStore metaDataStore;
    private ContributionLoader contributionLoader;
    private ContentTypeResolver contentTypeResolver;
    private DependencyResolver dependencyResolver;
    private ContributionServiceMonitor monitor;
    private List<ContributionServiceListener> listeners;

    public ContributionServiceImpl(@Reference ProcessorRegistry processorRegistry, @Reference MetaDataStore metaDataStore, @Reference ContributionLoader contributionLoader, @Reference ContentTypeResolver contentTypeResolver, @Reference DependencyResolver dependencyResolver, @Monitor ContributionServiceMonitor monitor) {
        this.processorRegistry = processorRegistry;
        this.metaDataStore = metaDataStore;
        this.contributionLoader = contributionLoader;
        this.contentTypeResolver = contentTypeResolver;
        this.dependencyResolver = dependencyResolver;
        this.monitor = monitor;
        this.listeners = new ArrayList<ContributionServiceListener>();
    }

    @Reference(required=false)
    public void setListeners(List<ContributionServiceListener> listeners) {
        this.listeners = listeners;
    }

    @Reference(required=false)
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Set<URI> getContributions() {
        Set contributions = this.metaDataStore.getContributions();
        HashSet<URI> uris = new HashSet<URI>(contributions.size());
        for (Contribution contribution : contributions) {
            uris.add(contribution.getUri());
        }
        return uris;
    }

    public boolean exists(URI uri) {
        return this.metaDataStore.find(uri) != null;
    }

    public long getContributionTimestamp(URI uri) {
        Contribution contribution = this.metaDataStore.find(uri);
        if (contribution == null) {
            return -1L;
        }
        return contribution.getTimestamp();
    }

    public List<Deployable> getDeployables(URI uri) throws ContributionNotFoundException {
        Contribution contribution = this.find(uri);
        ArrayList<Deployable> list = new ArrayList<Deployable>();
        if (contribution.getManifest() != null) {
            for (Deployable deployable : contribution.getManifest().getDeployables()) {
                list.add(deployable);
            }
        }
        return list;
    }

    public List<QName> getDeployedComposites(URI uri) throws ContributionNotFoundException {
        Contribution contribution = this.find(uri);
        List owners = contribution.getLockOwners();
        return new ArrayList<QName>(owners);
    }

    public URI store(ContributionSource contributionSource) throws StoreException {
        Contribution contribution = this.persist(contributionSource);
        this.metaDataStore.store(contribution);
        for (ContributionServiceListener listener : this.listeners) {
            listener.onStore(contribution);
        }
        return contribution.getUri();
    }

    public List<URI> store(List<ContributionSource> contributionSources) throws StoreException {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (ContributionSource contributionSource : contributionSources) {
            URI uri = this.store(contributionSource);
            uris.add(uri);
        }
        return uris;
    }

    public void install(URI uri) throws InstallException, ContributionNotFoundException {
        this.install(Collections.singletonList(uri));
    }

    public List<URI> install(List<URI> uris) throws InstallException, ContributionNotFoundException {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>(uris.size());
        for (URI uri : uris) {
            Contribution contribution = this.find(uri);
            contributions.add(contribution);
        }
        return this.installInOrder(contributions);
    }

    public void uninstall(URI uri) throws UninstallException, ContributionNotFoundException {
        Contribution contribution = this.find(uri);
        this.uninstall(contribution);
    }

    public void uninstall(List<URI> uris) throws UninstallException, ContributionNotFoundException {
        List<Contribution> contributions = new ArrayList(uris.size());
        for (URI uri : uris) {
            Contribution contribution = this.find(uri);
            contributions.add(contribution);
        }
        contributions = this.dependencyResolver.orderForUninstall(contributions);
        for (Contribution contribution : contributions) {
            this.uninstall(contribution);
        }
    }

    public void remove(URI uri) throws RemoveException, ContributionNotFoundException {
        Contribution contribution = this.find(uri);
        if (contribution.getState() != ContributionState.STORED) {
            throw new RemoveException("Contribution must first be uninstalled: " + uri);
        }
        this.metaDataStore.remove(uri);
        try {
            this.getRepository().remove(uri);
        }
        catch (RepositoryException e) {
            throw new RemoveException("Error removing contribution archive", (Throwable)e);
        }
        for (ContributionServiceListener listener : this.listeners) {
            listener.onRemove(contribution);
        }
    }

    public void remove(List<URI> uris) throws ContributionNotFoundException, RemoveException {
        for (URI uri : uris) {
            this.remove(uri);
        }
    }

    public boolean profileExists(URI uri) {
        for (Contribution contribution : this.metaDataStore.getContributions()) {
            if (!contribution.getProfiles().contains(uri)) continue;
            return true;
        }
        return false;
    }

    public List<URI> getContributionsInProfile(URI uri) {
        ArrayList<URI> profileContributions = new ArrayList<URI>();
        Set contributions = this.metaDataStore.getContributions();
        for (Contribution contribution : contributions) {
            if (!contribution.getProfiles().contains(uri)) continue;
            profileContributions.add(contribution.getUri());
        }
        return profileContributions;
    }

    public List<URI> getSortedContributionsInProfile(URI uri) {
        List<Contribution> sortedContributions = new ArrayList();
        Set contributions = this.metaDataStore.getContributions();
        for (Contribution contribution : contributions) {
            if (!contribution.getProfiles().contains(uri)) continue;
            sortedContributions.add(contribution);
        }
        ArrayList<URI> profileContributions = new ArrayList<URI>();
        sortedContributions = this.dependencyResolver.orderForUninstall(sortedContributions);
        for (Contribution contribution : sortedContributions) {
            profileContributions.add(contribution.getUri());
        }
        return profileContributions;
    }

    public void registerProfile(URI profileUri, List<URI> contributionUris) throws DuplicateProfileException {
        if (this.profileExists(profileUri)) {
            throw new DuplicateProfileException("Profile already installed: " + profileUri);
        }
        for (URI contributionUri : contributionUris) {
            Contribution contribution = this.metaDataStore.find(contributionUri);
            if (contribution == null) {
                throw new AssertionError((Object)("Contribution not found: " + contributionUri));
            }
            List profiles = contribution.getProfiles();
            if (profiles.contains(profileUri)) continue;
            profiles.add(profileUri);
            for (ContributionServiceListener listener : this.listeners) {
                listener.onUpdate(contribution);
            }
        }
    }

    public void installProfile(URI uri) throws InstallException, ContributionNotFoundException {
        ArrayList<Contribution> toInstall = new ArrayList<Contribution>();
        for (Contribution contribution : this.metaDataStore.getContributions()) {
            if (!contribution.getProfiles().contains(uri) || ContributionState.STORED != contribution.getState()) continue;
            toInstall.add(contribution);
        }
        if (toInstall.isEmpty()) {
            throw new ContributionNotFoundException("Profile not found: " + uri);
        }
        this.installInOrder(toInstall);
    }

    public void uninstallProfile(URI uri) throws UninstallException, ContributionNotFoundException {
        List<Contribution> toUninstall = new ArrayList();
        for (Contribution contribution : this.metaDataStore.getContributions()) {
            List profiles = contribution.getProfiles();
            if (!profiles.contains(uri) || profiles.size() != 1) continue;
            ContributionState state = contribution.getState();
            if (ContributionState.INSTALLED != state) {
                throw new UninstallException("Contribution not in installed state: " + state);
            }
            toUninstall.add(contribution);
        }
        toUninstall = this.dependencyResolver.orderForUninstall(toUninstall);
        for (Contribution contribution : toUninstall) {
            this.uninstall(contribution.getUri());
        }
    }

    public void removeProfile(URI uri) throws RemoveException, ContributionNotFoundException {
        ArrayList<Contribution> toRemove = new ArrayList<Contribution>();
        for (Contribution contribution : this.metaDataStore.getContributions()) {
            List profiles = contribution.getProfiles();
            if (!profiles.contains(uri)) continue;
            if (profiles.size() == 1) {
                ContributionState state = contribution.getState();
                if (ContributionState.STORED != state) {
                    throw new RemoveException("Contribution not in stored state: " + state);
                }
                toRemove.add(contribution);
                continue;
            }
            contribution.removeProfile(uri);
        }
        for (Contribution contribution : toRemove) {
            this.remove(contribution.getUri());
        }
    }

    public ContributionOrder processManifests(List<ContributionSource> contributionSources) throws InstallException, StoreException {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>();
        for (ContributionSource contributionSource : contributionSources) {
            Contribution contribution = this.persist(contributionSource);
            this.metaDataStore.store(contribution);
            for (ContributionServiceListener listener : this.listeners) {
                listener.onStore(contribution);
            }
            contributions.add(contribution);
        }
        return this.introspectManifests(contributions);
    }

    public void processContents(URI uri) throws InstallException, ContributionNotFoundException {
        Contribution contribution = this.find(uri);
        try {
            ClassLoader loader = this.contributionLoader.load(contribution);
            this.processContents(contribution, loader);
            contribution.setState(ContributionState.INSTALLED);
            for (ContributionServiceListener listener : this.listeners) {
                listener.onInstall(contribution);
            }
        }
        catch (InstallException e) {
            try {
                this.revertInstall(Collections.singletonList(contribution));
            }
            catch (RuntimeException ex) {
                this.monitor.error("Error reverting deployment", ex);
            }
            throw e;
        }
        String description = contribution.getManifest().getDescription();
        if (description != null) {
            this.monitor.installed(description);
        }
    }

    private ContributionOrder introspectManifests(List<Contribution> contributions) throws InstallException {
        ContributionOrder order = new ContributionOrder();
        for (Contribution contribution : contributions) {
            if (ContributionState.STORED == contribution.getState()) continue;
            throw new ContributionAlreadyInstalledException("Contribution is already installed: " + contribution.getUri());
        }
        for (Contribution contribution : contributions) {
            this.processManifest(contribution);
        }
        try {
            contributions = this.dependencyResolver.resolve(contributions);
        }
        catch (DependencyException e) {
            throw new InstallException((Throwable)e);
        }
        for (Contribution contribution : contributions) {
            boolean requiresLoad = false;
            ContributionManifest manifest = contribution.getManifest();
            for (Capability capability : manifest.getRequiredCapabilities()) {
                if (!capability.requiresLoad()) continue;
                requiresLoad = true;
                break;
            }
            if (requiresLoad) {
                order.addIsolatedContribution(contribution.getUri());
                continue;
            }
            order.addBaseContribution(contribution.getUri());
        }
        return order;
    }

    private Contribution find(URI uri) throws ContributionNotFoundException {
        Contribution contribution = this.metaDataStore.find(uri);
        if (contribution == null) {
            throw new ContributionNotFoundException("Contribution not found: " + uri);
        }
        return contribution;
    }

    private List<URI> installInOrder(List<Contribution> contributions) throws InstallException {
        for (Contribution contribution : contributions) {
            if (ContributionState.STORED == contribution.getState()) continue;
            throw new ContributionAlreadyInstalledException("Contribution is already installed: " + contribution.getUri());
        }
        for (Contribution contribution : contributions) {
            this.processManifest(contribution);
        }
        try {
            contributions = this.dependencyResolver.resolve(contributions);
        }
        catch (DependencyException e) {
            throw new InstallException((Throwable)e);
        }
        try {
            for (Contribution contribution : contributions) {
                ClassLoader loader = this.contributionLoader.load(contribution);
                this.processContents(contribution, loader);
                contribution.setState(ContributionState.INSTALLED);
                for (ContributionServiceListener listener : this.listeners) {
                    listener.onInstall(contribution);
                }
            }
        }
        catch (InstallException e) {
            try {
                this.revertInstall(contributions);
            }
            catch (RuntimeException ex) {
                this.monitor.error("Error reverting deployment", ex);
            }
            throw e;
        }
        ArrayList<URI> uris = new ArrayList<URI>(contributions.size());
        for (Contribution contribution : contributions) {
            URI uri = contribution.getUri();
            uris.add(uri);
            String description = contribution.getManifest().getDescription();
            if (description != null) {
                this.monitor.installed(description);
                continue;
            }
            if (contribution.getManifest().isExtension()) continue;
            this.monitor.installed(uri.toString());
        }
        return uris;
    }

    private void revertInstall(List<Contribution> contributions) {
        ListIterator<Contribution> iterator = contributions.listIterator(contributions.size());
        while (iterator.hasPrevious()) {
            Contribution contribution = iterator.previous();
            try {
                if (ContributionState.INSTALLED == contribution.getState()) {
                    this.uninstall(contribution);
                }
                this.contributionLoader.unload(contribution);
                this.remove(contribution.getUri());
            }
            catch (UninstallException ex) {
                this.monitor.error("Error reverting installation: " + contribution.getUri(), ex);
            }
            catch (ContributionNotFoundException ex) {
                this.monitor.error("Error reverting installation: " + contribution.getUri(), ex);
            }
            catch (RemoveException ex) {
                this.monitor.error("Error reverting installation: " + contribution.getUri(), ex);
            }
        }
    }

    private void uninstall(Contribution contribution) throws UninstallException {
        URI uri = contribution.getUri();
        if (contribution.getState() != ContributionState.INSTALLED) {
            throw new UninstallException("Contribution not installed: " + uri);
        }
        if (contribution.isLocked()) {
            List deployables = contribution.getLockOwners();
            throw new ContributionLockedException("Contribution is currently in use by a deployment: " + uri, uri, deployables);
        }
        this.contributionLoader.unload(contribution);
        contribution.setState(ContributionState.STORED);
        for (ContributionServiceListener listener : this.listeners) {
            listener.onUninstall(contribution);
        }
        String description = contribution.getManifest().getDescription();
        if (description != null) {
            this.monitor.uninstalled(description);
        } else if (!contribution.getManifest().isExtension()) {
            this.monitor.uninstalled(uri.toString());
        }
    }

    private void processManifest(Contribution contribution) throws InstallException {
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        this.processorRegistry.processManifest(contribution, (IntrospectionContext)context);
        if (context.hasErrors()) {
            URI uri = contribution.getUri();
            ArtifactValidationFailure failure = new ArtifactValidationFailure(uri, "the contribution manifest (sca-contribution.xml)");
            failure.addFailures(context.getErrors());
            ArrayList<ArtifactValidationFailure> failures = new ArrayList<ArtifactValidationFailure>();
            failures.add(failure);
            ArtifactValidationFailure warning = new ArtifactValidationFailure(uri, "the contribution manifest (sca-contribution.xml)");
            warning.addFailures(context.getWarnings());
            ArrayList<ArtifactValidationFailure> warnings = new ArrayList<ArtifactValidationFailure>();
            warnings.add(warning);
            throw new InvalidContributionException(failures, warnings);
        }
        for (ContributionServiceListener listener : this.listeners) {
            listener.onProcessManifest(contribution);
        }
    }

    private void processContents(Contribution contribution, ClassLoader loader) throws InstallException {
        try {
            URI contributionUri = contribution.getUri();
            DefaultIntrospectionContext context = new DefaultIntrospectionContext(contributionUri, loader);
            this.processorRegistry.indexContribution(contribution, (IntrospectionContext)context);
            if (context.hasErrors()) {
                throw new InvalidContributionException(context.getErrors(), context.getWarnings());
            }
            if (context.hasWarnings()) {
                this.monitor.contributionWarnings(ValidationUtils.outputWarnings((List)context.getWarnings()));
            }
            this.metaDataStore.store(contribution);
            context = new DefaultIntrospectionContext(contributionUri, loader);
            this.processorRegistry.processContribution(contribution, (IntrospectionContext)context);
            this.validateContribution(contribution, (IntrospectionContext)context);
            if (context.hasErrors()) {
                throw new InvalidContributionException(context.getErrors(), context.getWarnings());
            }
            if (context.hasWarnings()) {
                this.monitor.contributionWarnings(ValidationUtils.outputWarnings((List)context.getWarnings()));
            }
        }
        catch (StoreException e) {
            throw new InstallException((Throwable)e);
        }
    }

    private void validateContribution(Contribution contribution, IntrospectionContext context) {
        for (Deployable deployable : contribution.getManifest().getDeployables()) {
            QName name = deployable.getName();
            QNameSymbol symbol = new QNameSymbol(name);
            boolean found = false;
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement element : resource.getResourceElements()) {
                    if (!element.getSymbol().equals((Object)symbol)) continue;
                    found = true;
                }
            }
            if (found) continue;
            URI uri = contribution.getUri();
            InvalidDeployable failure = new InvalidDeployable("Deployable composite " + name + " not found in " + uri, name);
            context.addError((ValidationFailure)failure);
        }
    }

    private Contribution persist(ContributionSource contributionSource) throws StoreException {
        Source source;
        URL locationUrl;
        URI contributionUri = contributionSource.getUri();
        if (this.metaDataStore.find(contributionUri) != null) {
            throw new DuplicateContributionException("Contribution already exists: " + contributionUri);
        }
        boolean persistent = contributionSource.persist();
        if (!persistent) {
            locationUrl = contributionSource.getLocation();
            source = contributionSource.getSource();
        } else {
            InputStream stream = null;
            try {
                stream = contributionSource.getSource().openStream();
                boolean extension = contributionSource.isExtension();
                locationUrl = this.getRepository().store(contributionUri, stream, extension);
                source = new UrlSource(locationUrl);
            }
            catch (IOException e) {
                throw new StoreException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new StoreException((Throwable)e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    this.monitor.error("Error closing contribution stream", e);
                }
            }
        }
        String type = contributionSource.getContentType();
        if (type == null && locationUrl == null) {
            throw new StoreException("Content type could not be determined for contribution: " + contributionUri);
        }
        if (type == null) {
            try {
                type = this.contentTypeResolver.getContentType(locationUrl);
            }
            catch (ContentTypeResolutionException e) {
                throw new StoreException((Throwable)e);
            }
        }
        long timestamp = contributionSource.getTimestamp();
        return new Contribution(contributionUri, source, locationUrl, timestamp, type, persistent);
    }

    private Repository getRepository() {
        if (this.repository == null) {
            throw new UnsupportedOperationException(Repository.class.getSimpleName() + " not configured");
        }
        return this.repository;
    }
}

