/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.spi.contribution.ContentTypeResolutionException;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.oasisopen.sca.annotation.Init;

public class ExtensionMapContentTypeResolver
implements ContentTypeResolver {
    private Map<String, String> extensionMap = new HashMap<String, String>();

    @Init
    public void init() {
        this.extensionMap.put("xml", "application/xml");
        this.extensionMap.put("composite", "text/vnd.fabric3.composite+xml");
        this.extensionMap.put("zip", "application/zip");
        this.extensionMap.put("jar", "application/zip");
        this.extensionMap.put("definitions", "text/vnd.fabric3.definitions+xml");
        this.extensionMap.put("wsdl", "text/wsdl+xml");
        this.extensionMap.put("contribution", "text/vnd.fabric3.contribution");
    }

    public String getContentType(URL contentUrl) throws ContentTypeResolutionException {
        if (contentUrl == null) {
            throw new IllegalArgumentException("Content URL cannot be null");
        }
        String urlString = contentUrl.toExternalForm();
        try {
            String contentType = this.getContentType(urlString);
            if (contentType == null) {
                URLConnection connection = contentUrl.openConnection();
                contentType = connection.getContentType();
            }
            if (contentType == null || "application/octet-stream".equals(contentType)) {
                return null;
            }
            return contentType;
        }
        catch (IOException ex) {
            throw new ContentTypeResolutionException("Unable to resolve content type: " + urlString, urlString, (Throwable)ex);
        }
    }

    public void register(String fileExtension, String contentType) {
        this.extensionMap.put(fileExtension, contentType);
    }

    public void unregister(String fileExtension) {
        this.extensionMap.remove(fileExtension);
    }

    private String getContentType(String pathURI) {
        String extension;
        String contentType;
        int extensionIndex = pathURI.lastIndexOf(46);
        if (extensionIndex != -1 && (contentType = this.extensionMap.get(extension = pathURI.substring(extensionIndex + 1))) != null) {
            return contentType;
        }
        return null;
    }
}

