/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.contribution.ContributionResolutionException;
import org.fabric3.contribution.ContributionUpdateException;
import org.fabric3.contribution.wire.ContributionWireInstantiatorRegistry;
import org.fabric3.host.Names;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.contribution.UnresolvedImportException;
import org.fabric3.model.type.ModelObject;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.ReferenceIntrospector;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceElementUpdater;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataStoreImpl
implements MetaDataStore {
    private ProcessorRegistry processorRegistry;
    private ContributionWireInstantiatorRegistry instantiatorRegistry;
    private Map<String, ReferenceIntrospector> referenceIntrospectors = new HashMap<String, ReferenceIntrospector>();
    private Map<String, ResourceElementUpdater<?>> updaters = new HashMap();
    private Map<URI, Contribution> cache = new ConcurrentHashMap<URI, Contribution>();

    public MetaDataStoreImpl(ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Reference
    public void setProcessorRegistry(ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Reference
    public void setInstantiatorRegistry(ContributionWireInstantiatorRegistry instantiatorRegistry) {
        this.instantiatorRegistry = instantiatorRegistry;
    }

    @Reference(required=false)
    public void setReferenceIntrospectors(Map<String, ReferenceIntrospector> introspectors) {
        this.referenceIntrospectors = introspectors;
    }

    @Reference(required=false)
    public void setUpdaters(Map<String, ResourceElementUpdater<?>> updaters) {
        this.updaters = updaters;
    }

    public void store(Contribution contribution) throws StoreException {
        this.cache.put(contribution.getUri(), contribution);
    }

    public Contribution find(URI contributionUri) {
        return this.cache.get(contributionUri);
    }

    public Set<Contribution> getContributions() {
        return new HashSet<Contribution>(this.cache.values());
    }

    public void remove(URI contributionUri) {
        this.cache.remove(contributionUri);
    }

    public <S extends Symbol, V extends Serializable> ResourceElement<S, V> find(Class<V> type, S symbol) {
        for (Contribution contribution : this.cache.values()) {
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement element : resource.getResourceElements()) {
                    if (!element.getSymbol().equals(symbol)) continue;
                    if (ResourceState.UNPROCESSED == resource.getState()) {
                        throw new AssertionError((Object)"Attempt to resolve a resource before it is processed or is in error");
                    }
                    return element;
                }
            }
        }
        return null;
    }

    public <S extends Symbol, V extends Serializable> ResourceElement<S, V> find(URI uri, Class<V> type, S symbol) throws StoreException {
        return this.resolve(uri, type, symbol, null);
    }

    public <S extends Symbol> Set<ResourceElement<S, ?>> findReferences(URI uri, S symbol) throws StoreException {
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new ContributionResolutionException("Contribution not found: " + identifier, identifier);
        }
        ResourceElement<S, Serializable> referred = this.find(uri, Serializable.class, symbol);
        if (referred == null) {
            return Collections.emptySet();
        }
        ReferenceIntrospector introspector = this.referenceIntrospectors.get(referred.getValue().getClass().getName());
        if (introspector == null) {
            return Collections.emptySet();
        }
        HashSet elements = new HashSet();
        this.findReferences(contribution, referred, elements, introspector);
        for (ContributionWire wire : contribution.getWires()) {
            if (!wire.resolves(symbol)) continue;
            URI resolvedUri = wire.getExportContributionUri();
            Contribution resolved = this.cache.get(resolvedUri);
            if (resolved == null) {
                throw new AssertionError((Object)("Dependent contribution not found: " + resolvedUri));
            }
            this.findReferences(resolved, referred, elements, introspector);
        }
        return elements;
    }

    public <V extends Serializable> Set<ModelObject> update(URI uri, V value) throws StoreException {
        ResourceElementUpdater<V> updater = this.getUpdater(uri, value);
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new ContributionResolutionException("Contribution not found: " + identifier, identifier);
        }
        Set<Contribution> dependentContributions = this.resolveDependentContributions(uri);
        return updater.update(value, contribution, dependentContributions);
    }

    public <V extends Serializable> Set<ModelObject> remove(URI uri, V value) throws StoreException {
        ResourceElementUpdater<V> updater = this.getUpdater(uri, value);
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new ContributionResolutionException("Contribution not found: " + identifier, identifier);
        }
        Set<Contribution> dependentContributions = this.resolveDependentContributions(uri);
        return updater.remove(value, contribution, dependentContributions);
    }

    public <S extends Symbol, V extends Serializable> ResourceElement<S, V> resolve(URI uri, Class<V> type, S symbol, IntrospectionContext context) throws StoreException {
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new ContributionResolutionException("Contribution not found: " + identifier, identifier);
        }
        return this.resolve(contribution, type, symbol, context);
    }

    public <V extends Serializable> List<ResourceElement<?, V>> resolve(URI uri, Class<V> type) throws StoreException {
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new ContributionResolutionException("Contribution not found: " + identifier, identifier);
        }
        ArrayList artifacts = new ArrayList();
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement element : resource.getResourceElements()) {
                Object value = element.getValue();
                if (value == null || !value.getClass().isAssignableFrom(type)) continue;
                artifacts.add(element);
            }
        }
        for (ContributionWire wire : contribution.getWires()) {
            URI exportingUri = wire.getExportContributionUri();
            Contribution exporting = this.find(exportingUri);
            for (Resource resource : exporting.getResources()) {
                for (ResourceElement element : resource.getResourceElements()) {
                    Object value;
                    if (!wire.resolves(element.getSymbol()) || (value = element.getValue()) == null || !value.getClass().isAssignableFrom(type)) continue;
                    artifacts.add(element);
                }
            }
        }
        return artifacts;
    }

    public List<Contribution> resolve(URI uri, Import imprt) {
        ArrayList<Contribution> resolved = new ArrayList<Contribution>();
        if (!imprt.getResolved().isEmpty()) {
            for (URI exportUri : imprt.getResolved().keySet()) {
                Contribution contribution = this.cache.get(exportUri);
                if (contribution == null) {
                    throw new AssertionError((Object)("Contribution not found: " + contribution));
                }
                resolved.add(contribution);
            }
            return resolved;
        }
        URI location = imprt.getLocation();
        for (Contribution contribution : this.cache.values()) {
            for (Export export : contribution.getManifest().getExports()) {
                if (!export.match(imprt)) continue;
                if (location != null) {
                    if (!location.equals(contribution.getUri())) continue;
                    resolved.add(contribution);
                    imprt.addResolved(contribution.getUri(), export);
                    export.resolve();
                    return resolved;
                }
                if (uri.equals(contribution.getUri())) continue;
                resolved.add(contribution);
                imprt.addResolved(contribution.getUri(), export);
                export.resolve();
            }
        }
        return resolved;
    }

    public List<ContributionWire<?, ?>> resolveContributionWires(URI uri, Import imprt) throws UnresolvedImportException {
        ArrayList wires = new ArrayList();
        for (Map.Entry entry : imprt.getResolved().entrySet()) {
            ContributionWire<Import, Export> wire = this.instantiatorRegistry.instantiate(imprt, (Export)entry.getValue(), uri, (URI)entry.getKey());
            wires.add(wire);
        }
        if (wires.isEmpty()) {
            throw new UnresolvedImportException(imprt.toString());
        }
        return wires;
    }

    public Set<Contribution> resolveDependentContributions(URI uri) {
        HashSet<Contribution> dependents = new HashSet<Contribution>();
        block0: for (Contribution entry : this.cache.values()) {
            List contributionWires = entry.getWires();
            for (ContributionWire wire : contributionWires) {
                if (!uri.equals(wire.getExportContributionUri())) continue;
                dependents.add(entry);
                continue block0;
            }
        }
        return dependents;
    }

    public List<Contribution> resolveExtensionProviders(String name) {
        ArrayList<Contribution> providers = new ArrayList<Contribution>();
        block0: for (Contribution contribution : this.cache.values()) {
            for (String extend : contribution.getManifest().getExtends()) {
                if (!extend.equals(name)) continue;
                providers.add(contribution);
                continue block0;
            }
        }
        return providers;
    }

    public List<Contribution> resolveExtensionPoints(String name) {
        ArrayList<Contribution> extensionPoints = new ArrayList<Contribution>();
        block0: for (Contribution contribution : this.cache.values()) {
            for (String extensionPoint : contribution.getManifest().getExtensionPoints()) {
                if (!extensionPoint.equals(name)) continue;
                extensionPoints.add(contribution);
                continue block0;
            }
        }
        return extensionPoints;
    }

    public Set<Contribution> resolveCapabilities(Contribution contribution) {
        HashSet<Contribution> extensions = new HashSet<Contribution>();
        return this.resolveCapabilities(contribution, extensions);
    }

    public Set<Contribution> resolveCapability(String capability) {
        HashSet<Contribution> extensions = new HashSet<Contribution>();
        for (Contribution entry : this.cache.values()) {
            Capability key = new Capability(capability);
            if (!entry.getManifest().getProvidedCapabilities().contains(key) || extensions.contains(entry)) continue;
            extensions.add(entry);
            this.resolveCapabilities(entry, extensions);
        }
        return extensions;
    }

    private <S extends Symbol, V extends Serializable> ResourceElement<S, V> resolve(Contribution contribution, Class<V> type, S symbol, IntrospectionContext context) throws StoreException {
        ResourceElement<S, V> element;
        for (ContributionWire wire : contribution.getWires()) {
            if (!wire.resolves(symbol)) continue;
            URI resolvedUri = wire.getExportContributionUri();
            Contribution resolved = this.cache.get(resolvedUri);
            if (resolved == null) {
                throw new AssertionError((Object)("Dependent contribution not found: " + resolvedUri));
            }
            element = this.resolve(resolved, type, symbol, context);
            if (element == null) continue;
            return element;
        }
        element = this.resolveInternal(contribution, type, symbol, context);
        if (element != null) {
            return element;
        }
        return null;
    }

    private <S extends Symbol> void findReferences(Contribution contribution, ResourceElement<S, ?> referred, Set<ResourceElement<S, ?>> elements, ReferenceIntrospector introspector) {
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement element : resource.getResourceElements()) {
                if (!introspector.references(referred, element)) continue;
                elements.add(element);
            }
        }
    }

    private Set<Contribution> resolveCapabilities(Contribution contribution, Set<Contribution> extensions) {
        Set required = contribution.getManifest().getRequiredCapabilities();
        for (Capability capability : required) {
            for (Contribution entry : this.cache.values()) {
                if (!entry.getManifest().getProvidedCapabilities().contains(capability) || extensions.contains(entry)) continue;
                extensions.add(entry);
                this.resolveCapabilities(entry, extensions);
            }
        }
        for (ContributionWire wire : contribution.getWires()) {
            Contribution imported = this.cache.get(wire.getExportContributionUri());
            if (imported.getManifest().isExtension() && !extensions.contains(imported) && !imported.getUri().equals(Names.HOST_CONTRIBUTION) && !imported.getUri().equals(Names.BOOT_CONTRIBUTION)) {
                extensions.add(imported);
            }
            this.resolveCapabilities(imported, extensions);
        }
        for (URI uri : contribution.getResolvedExtensionProviders()) {
            Contribution provider = this.cache.get(uri);
            if (extensions.contains(provider)) continue;
            extensions.add(provider);
        }
        return extensions;
    }

    private <S extends Symbol, V extends Serializable> ResourceElement<S, V> resolveInternal(Contribution contribution, Class<V> type, S symbol, IntrospectionContext context) throws StoreException {
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement element : resource.getResourceElements()) {
                Object val;
                if (!element.getSymbol().equals(symbol)) continue;
                if (ResourceState.UNPROCESSED == resource.getState() && context == null) {
                    String identifier = resource.getSource().getSystemId();
                    throw new AssertionError((Object)("Resource not resolved: " + identifier));
                }
                if (ResourceState.UNPROCESSED == resource.getState() && context != null) {
                    try {
                        this.processorRegistry.processResource(resource, context);
                    }
                    catch (ContributionException e) {
                        String identifier = resource.getSource().getSystemId();
                        throw new StoreException("Error resolving resource: " + identifier, (Throwable)e);
                    }
                }
                if (!type.isInstance(val = element.getValue())) {
                    throw new IllegalArgumentException("Invalid type for symbol. Expected: " + type + " was: " + val);
                }
                return element;
            }
        }
        return null;
    }

    private <V extends Serializable> ResourceElementUpdater<V> getUpdater(URI uri, V value) throws ContributionUpdateException {
        String clazz = value.getClass().getName();
        ResourceElementUpdater<?> updater = this.updaters.get(clazz);
        if (updater == null) {
            String identifier = uri.toString();
            throw new ContributionUpdateException("Updater not found: " + identifier);
        }
        return updater;
    }
}

