/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.net.URL;
import java.util.List;
import org.fabric3.contribution.archive.AbstractContributionProcessor;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.UnsupportedContentTypeException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.archive.Action;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveContributionProcessor
extends AbstractContributionProcessor {
    private List<ArchiveContributionHandler> handlers;

    @Reference
    public void setHandlers(List<ArchiveContributionHandler> handlers) {
        this.handlers = handlers;
    }

    public boolean canProcess(Contribution contribution) {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return true;
        }
        return false;
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        handler.processManifest(contribution, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(Contribution contribution, final IntrospectionContext context) throws InstallException {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            handler.iterateArtifacts(contribution, new Action(){

                public void process(Contribution contribution, String contentType, URL url) throws InstallException {
                    UrlSource source = new UrlSource(url);
                    ArchiveContributionProcessor.this.registry.indexResource(contribution, contentType, (Source)source, context);
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Contribution contribution, IntrospectionContext context) throws InstallException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            for (Resource resource : contribution.getResources()) {
                if (ResourceState.UNPROCESSED != resource.getState()) continue;
                this.registry.processResource(resource, context);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private ArchiveContributionHandler getHandler(Contribution contribution) throws UnsupportedContentTypeException {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return handler;
        }
        String source = contribution.getUri().toString();
        throw new UnsupportedContentTypeException("Contribution type not supported: " + source);
    }
}

