/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.host.util.FileHelper;
import org.fabric3.spi.contribution.ContentTypeResolutionException;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.archive.Action;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.oasisopen.sca.annotation.Reference;

public class ExplodedArchiveContributionHandler
implements ArchiveContributionHandler {
    private Loader loader;
    private final ContentTypeResolver contentTypeResolver;

    public ExplodedArchiveContributionHandler(@Reference Loader loader, @Reference ContentTypeResolver contentTypeResolver) {
        this.loader = loader;
        this.contentTypeResolver = contentTypeResolver;
    }

    public boolean canProcess(Contribution contribution) {
        URL location = contribution.getLocation();
        if (location == null || !"file".equals(location.getProtocol())) {
            return false;
        }
        File file = new File(location.getFile());
        String contentType = contribution.getContentType();
        return file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip") || "text/vnd.fabric3.exploded".equals(contentType));
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        try {
            String sourceUrl = contribution.getLocation().toString();
            URL manifestUrl = new URL(sourceUrl + "/META-INF/sca-contribution.xml");
            File file = new File(manifestUrl.getPath());
            if (!file.exists()) {
                manifestUrl = new URL(sourceUrl + "/WEB-INF/sca-contribution.xml");
            }
            ClassLoader cl = this.getClass().getClassLoader();
            URI uri = contribution.getUri();
            DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(uri, cl);
            UrlSource source = new UrlSource(manifestUrl);
            ContributionManifest manifest = (ContributionManifest)this.loader.load((Source)source, ContributionManifest.class, (IntrospectionContext)childContext);
            if (childContext.hasErrors()) {
                context.addErrors(childContext.getErrors());
            }
            if (childContext.hasWarnings()) {
                context.addWarnings(childContext.getWarnings());
            }
            contribution.setManifest(manifest);
        }
        catch (LoaderException e) {
            if (!(e.getCause() instanceof FileNotFoundException)) {
                throw new InstallException((Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public void iterateArtifacts(Contribution contribution, Action action) throws InstallException {
        File root = FileHelper.toFile((URL)contribution.getLocation());
        this.iterateArtifactsRecursive(contribution, action, root, root);
    }

    protected void iterateArtifactsRecursive(Contribution contribution, Action action, File dir, File root) throws InstallException {
        File[] files = dir.listFiles();
        ContributionManifest manifest = contribution.getManifest();
        for (File file : files) {
            if (file.isDirectory()) {
                this.iterateArtifactsRecursive(contribution, action, file, root);
                continue;
            }
            try {
                URL entryUrl;
                String contentType;
                if (file.getName().equals("sca-contribution.xml") || (contentType = this.contentTypeResolver.getContentType(entryUrl = file.toURI().toURL())) == null || this.exclude(manifest, file, root)) continue;
                action.process(contribution, contentType, entryUrl);
            }
            catch (MalformedURLException e) {
                throw new InstallException((Throwable)e);
            }
            catch (IOException e) {
                throw new InstallException((Throwable)e);
            }
            catch (ContentTypeResolutionException e) {
                throw new InstallException((Throwable)e);
            }
        }
    }

    private boolean exclude(ContributionManifest manifest, File file, File root) {
        for (Pattern pattern : manifest.getScanExcludes()) {
            String relativePathName;
            if (!pattern.matcher(relativePathName = file.toURI().toString().substring(root.toURI().toString().length())).matches()) continue;
            return true;
        }
        return false;
    }
}

