/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.util.IOHelper;
import org.fabric3.spi.contribution.archive.ClasspathProcessor;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.fabric3.spi.model.os.Library;
import org.fabric3.spi.model.os.OperatingSystemSpec;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JarClasspathProcessor
implements ClasspathProcessor {
    private ClasspathProcessorRegistry registry;
    private HostInfo hostInfo;
    private boolean explodeJars;
    private File libraryDir;

    public JarClasspathProcessor(@Reference ClasspathProcessorRegistry registry, @Reference HostInfo hostInfo) {
        this.registry = registry;
        this.hostInfo = hostInfo;
        this.libraryDir = hostInfo.getNativeLibraryDir();
    }

    @Property(required=false)
    public void setExplodeJars(boolean explodeJars) {
        this.explodeJars = explodeJars;
    }

    @Init
    public void init() {
        this.registry.register((ClasspathProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregister((ClasspathProcessor)this);
    }

    public boolean canProcess(URL url) {
        String name = url.getFile().toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith("/classes") || name.endsWith("/classes/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> process(URL jar, List<Library> libraries) throws IOException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        classpath.add(jar);
        File dir = this.hostInfo.getTempDir();
        InputStream is = jar.openStream();
        Set<String> resolvedLibraryPaths = this.resolveNativeLibraries(libraries);
        try {
            JarEntry entry;
            JarInputStream jarStream = new JarInputStream(is);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                int index = entry.getName().lastIndexOf("/");
                String path = index > 0 ? entry.getName().substring(0, index) : entry.getName();
                if (resolvedLibraryPaths.contains(entry.getName())) {
                    this.extractNativeLibrary(path, jarStream, entry);
                    continue;
                }
                if (!path.startsWith("META-INF/lib")) continue;
                if (this.explodeJars) {
                    String fileName = path.substring(path.lastIndexOf(47));
                    File explodedDirectory = new File(dir, fileName);
                    this.explodeJar(dir, jarStream, explodedDirectory);
                    classpath.add(explodedDirectory.toURI().toURL());
                    continue;
                }
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File jarFile = File.createTempFile("fabric3", ".jar", dir);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile));
                try {
                    IOHelper.copy((InputStream)jarStream, (OutputStream)os);
                    ((OutputStream)os).flush();
                }
                finally {
                    ((OutputStream)os).close();
                }
                jarFile.deleteOnExit();
                classpath.add(jarFile.toURI().toURL());
            }
            ArrayList<URL> arrayList = classpath;
            return arrayList;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractNativeLibrary(String path, JarInputStream jarStream, JarEntry entry) throws IOException {
        String libraryName;
        File library;
        File dir = this.hostInfo.getTempDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!this.libraryDir.exists()) {
            this.libraryDir.mkdirs();
            this.libraryDir.deleteOnExit();
        }
        if ((library = new File(this.libraryDir, libraryName = entry.getName().substring(path.length() + 1))).exists()) {
            return;
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(library));
        try {
            IOHelper.copy((InputStream)jarStream, (OutputStream)os);
            ((OutputStream)os).flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        library.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explodeJar(File dir, JarInputStream jarStream, File explodedDirectory) throws IOException {
        if (!explodedDirectory.exists()) {
            explodedDirectory.mkdirs();
            File jarFile = File.createTempFile("fabric3", ".jar", dir);
            jarFile.createNewFile();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile));
            try {
                IOHelper.copy((InputStream)jarStream, (OutputStream)os);
                ((OutputStream)os).flush();
            }
            finally {
                ((OutputStream)os).close();
            }
            try {
                JarEntry entry;
                FileInputStream inputStream = new FileInputStream(jarFile);
                JarInputStream jarInputStream = new JarInputStream(inputStream);
                while ((entry = jarInputStream.getNextJarEntry()) != null) {
                    String filePath = entry.getName();
                    if (entry.isDirectory()) continue;
                    File entryFile = new File(explodedDirectory, filePath);
                    entryFile.getParentFile().mkdirs();
                    entryFile.createNewFile();
                    BufferedOutputStream entryOutputStream = new BufferedOutputStream(new FileOutputStream(entryFile));
                    IOHelper.copy((InputStream)jarInputStream, (OutputStream)entryOutputStream);
                    ((OutputStream)entryOutputStream).flush();
                    ((OutputStream)entryOutputStream).close();
                }
                inputStream.close();
            }
            finally {
                jarFile.delete();
            }
        }
    }

    private Set<String> resolveNativeLibraries(List<Library> libraries) {
        HashSet<String> paths = new HashSet<String>();
        block0: for (Library library : libraries) {
            for (OperatingSystemSpec os : library.getOperatingSystems()) {
                if (!os.matches(this.hostInfo.getOperatingSystem())) continue;
                paths.add(library.getPath());
                continue block0;
            }
        }
        return paths;
    }
}

