/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.host.util.FileHelper;
import org.fabric3.spi.contribution.archive.ClasspathProcessor;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.fabric3.spi.model.os.Library;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SyntheticDirectoryClasspathProcessor
implements ClasspathProcessor {
    private final ClasspathProcessorRegistry registry;

    public SyntheticDirectoryClasspathProcessor(@Reference ClasspathProcessorRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.register((ClasspathProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregister((ClasspathProcessor)this);
    }

    public boolean canProcess(URL url) {
        if (!"file".equals(url.getProtocol())) {
            return false;
        }
        File root = FileHelper.toFile((URL)url);
        return root.isDirectory();
    }

    public List<URL> process(URL url, List<Library> libraries) throws IOException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        File root = FileHelper.toFile((URL)url);
        for (File file : root.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            classpath.add(file.toURI().toURL());
        }
        return classpath;
    }
}

