/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.spi.contribution.ContentTypeResolutionException;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.archive.Action;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.contribution.manifest.JarManifestHandler;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipContributionHandler
implements ArchiveContributionHandler {
    private List<JarManifestHandler> manifestHandlers = Collections.emptyList();
    private final Loader loader;
    private final ContentTypeResolver contentTypeResolver;

    public ZipContributionHandler(@Reference Loader loader, @Reference ContentTypeResolver contentTypeResolver) {
        this.loader = loader;
        this.contentTypeResolver = contentTypeResolver;
    }

    @Reference(required=false)
    public void setManifestHandlers(List<JarManifestHandler> manifestHandlers) {
        this.manifestHandlers = manifestHandlers;
    }

    public boolean canProcess(Contribution contribution) {
        String sourceUrl = contribution.getLocation().toString();
        return sourceUrl.endsWith(".jar") || sourceUrl.endsWith(".zip");
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        URL sourceUrl = contribution.getLocation();
        try {
            URL manifestUrl = new URL("jar:" + sourceUrl.toExternalForm() + "!/META-INF/sca-contribution.xml");
            ClassLoader cl = this.getClass().getClassLoader();
            URI uri = contribution.getUri();
            DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(uri, cl);
            UrlSource source = new UrlSource(manifestUrl);
            ContributionManifest manifest = (ContributionManifest)this.loader.load((Source)source, ContributionManifest.class, (IntrospectionContext)childContext);
            if (childContext.hasErrors()) {
                context.addErrors(childContext.getErrors());
            }
            if (childContext.hasWarnings()) {
                context.addWarnings(childContext.getWarnings());
            }
            if (childContext.hasErrors() || childContext.hasWarnings()) {
                return;
            }
            contribution.setManifest(manifest);
        }
        catch (LoaderException e) {
            if (!(e.getCause() instanceof FileNotFoundException)) {
                throw new InstallException((Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        InputStream manifestStream = null;
        try {
            URL jarUrl = new URL("jar:" + sourceUrl.toExternalForm() + "!/META-INF/MANIFEST.MF");
            manifestStream = jarUrl.openStream();
            Manifest jarManifest = new Manifest(manifestStream);
            for (JarManifestHandler handler : this.manifestHandlers) {
                handler.processManifest(contribution.getManifest(), jarManifest, context);
            }
        }
        catch (MalformedURLException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void iterateArtifacts(Contribution contribution, Action action) throws InstallException {
        URL location = contribution.getLocation();
        ContributionManifest manifest = contribution.getManifest();
        ZipInputStream zipStream = null;
        try {
            ZipEntry entry;
            zipStream = new ZipInputStream(location.openStream());
            while ((entry = zipStream.getNextEntry()) != null) {
                String contentType;
                if (entry.isDirectory() || entry.getName().contains("META-INF/sca-contribution.xml") || this.exclude(manifest, entry) || (contentType = this.contentTypeResolver.getContentType(new URL(location, entry.getName()))) == null) continue;
                URL entryUrl = new URL("jar:" + location.toExternalForm() + "!/" + entry.getName());
                action.process(contribution, contentType, entryUrl);
            }
        }
        catch (ContentTypeResolutionException e) {
            throw new InstallException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new InstallException((Throwable)e);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean exclude(ContributionManifest manifest, ZipEntry entry) {
        for (Pattern pattern : manifest.getScanExcludes()) {
            if (!pattern.matcher(entry.getName()).matches()) continue;
            return true;
        }
        return false;
    }
}

