/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.contribution.manifest.ContributionImport;
import org.fabric3.contribution.manifest.MissingManifestAttribute;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ContributionImportLoader
extends AbstractValidatingTypeLoader<ContributionImport> {
    private URI INVALID_URI = URI.create("invalid");

    public ContributionImportLoader() {
        this.addAttributes(new String[]{"uri"});
    }

    public ContributionImport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String uriStr = reader.getAttributeValue(null, "uri");
        if (uriStr == null) {
            MissingManifestAttribute failure = new MissingManifestAttribute("The uri attribute must be specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        try {
            URI uri = new URI(uriStr);
            return new ContributionImport(uri);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid uri attribute", reader, (Throwable)e);
            context.addError((ValidationFailure)error);
            return new ContributionImport(this.INVALID_URI);
        }
    }
}

