/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.contribution.manifest.MissingPackage;
import org.fabric3.host.Version;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.contribution.manifest.JavaImport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaImportLoader
extends AbstractValidatingTypeLoader<JavaImport> {
    public JavaImportLoader() {
        this.addAttributes(new String[]{"package", "required", "version", "min", "location", "minInclusive", "max", "maxInclusive"});
    }

    public JavaImport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String statement = reader.getAttributeValue(null, "package");
        if (statement == null) {
            MissingPackage failure = new MissingPackage("No package name specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String requiredAttr = reader.getAttributeValue(null, "required");
        boolean required = requiredAttr == null || Boolean.parseBoolean(requiredAttr);
        String version = reader.getAttributeValue(null, "version");
        String minVersion = reader.getAttributeValue(null, "min");
        PackageInfo info = version != null ? this.parseVersion(statement, version, required, reader, context) : (minVersion != null ? this.parseRange(statement, minVersion, required, reader, context) : new PackageInfo(statement, required));
        if (info == null) {
            return null;
        }
        URI locationUri = null;
        String location = reader.getAttributeValue(null, "location");
        if (location != null) {
            try {
                locationUri = new URI(location);
            }
            catch (URISyntaxException e) {
                InvalidValue error = new InvalidValue("Invalid location attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        return new JavaImport(info, locationUri);
    }

    private PackageInfo parseVersion(String statement, String version, boolean required, XMLStreamReader reader, IntrospectionContext context) {
        try {
            String minInclusiveAttr = reader.getAttributeValue(null, "minInclusive");
            boolean minInclusive = minInclusiveAttr == null || Boolean.parseBoolean(minInclusiveAttr);
            Version packageVersion = new Version(version);
            return new PackageInfo(statement, packageVersion, minInclusive, required);
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid import package version", reader, (Throwable)e);
            context.addError((ValidationFailure)failure);
            return null;
        }
    }

    private PackageInfo parseRange(String statement, String minVersion, boolean required, XMLStreamReader reader, IntrospectionContext context) {
        String maxInclusiveAttr;
        Version minimum;
        String minInclusiveAttr = reader.getAttributeValue(null, "minInclusive");
        boolean minInclusive = minInclusiveAttr == null || Boolean.parseBoolean(minInclusiveAttr);
        String maxVersion = reader.getAttributeValue(null, "max");
        Version maximum = null;
        try {
            minimum = new Version(minVersion);
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid minimum package version", reader, (Throwable)e);
            context.addError((ValidationFailure)failure);
            return null;
        }
        if (maxVersion != null) {
            try {
                maximum = new Version(maxVersion);
            }
            catch (IllegalArgumentException e) {
                InvalidValue failure = new InvalidValue("Invalid maximum package version", reader, (Throwable)e);
                context.addError((ValidationFailure)failure);
                return null;
            }
        }
        boolean maxInclusive = (maxInclusiveAttr = reader.getAttributeValue(null, "maxInclusive")) == null || Boolean.parseBoolean(maxInclusiveAttr);
        return new PackageInfo(statement, minimum, minInclusive, maximum, maxInclusive, required);
    }
}

