/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

public class OSGiManifestEntryParser {
    private static final char PARAMETER_SEPARATOR = ';';
    private static final char SEPARATOR = ',';
    private String header;
    private EventType state;
    private StringBuilder text;
    private int pos = 0;
    private boolean inQuote;

    public OSGiManifestEntryParser(String header) {
        assert (header != null);
        this.header = header;
        this.state = EventType.BEGIN;
    }

    public EventType next() {
        if (this.pos <= this.header.length() - 1) {
            if (EventType.END_CLAUSE == this.state) {
                this.state = EventType.PATH;
                return EventType.END_CLAUSE;
            }
            if (EventType.PATH == this.state || EventType.PARAMETER == this.state) {
                this.text = null;
            }
            while (this.pos <= this.header.length() - 1) {
                char c = this.header.charAt(this.pos);
                ++this.pos;
                if (';' == c) {
                    this.inQuote = false;
                    if (EventType.PATH == this.state || EventType.BEGIN == this.state) {
                        this.state = EventType.PARAMETER;
                        return EventType.PATH;
                    }
                    return this.state;
                }
                if (',' == c) {
                    if (this.inQuote) {
                        this.appendNoWhiteSpace(c);
                        continue;
                    }
                    EventType current = this.state;
                    if (EventType.BEGIN == this.state) {
                        current = EventType.PATH;
                    }
                    this.state = EventType.END_CLAUSE;
                    return current;
                }
                if (this.inQuote && c == '\"') {
                    this.inQuote = false;
                } else if (c == '\"') {
                    this.inQuote = true;
                }
                this.appendNoWhiteSpace(c);
                if (this.pos != this.header.length() || this.state != EventType.BEGIN && this.state != EventType.PATH) continue;
                this.state = EventType.PATH;
            }
            return this.state;
        }
        this.state = this.state == EventType.END_CLAUSE ? EventType.END : EventType.END_CLAUSE;
        return this.state;
    }

    public String getText() {
        if (this.state != EventType.PATH && this.state != EventType.PARAMETER && this.state != EventType.END_CLAUSE) {
            throw new IllegalStateException("Invalid state:" + (Object)((Object)this.state));
        }
        return this.text.toString();
    }

    private void appendNoWhiteSpace(char c) {
        if (this.text == null) {
            this.text = new StringBuilder();
        }
        if (Character.isWhitespace(c) || c == '\n') {
            return;
        }
        this.text.append(c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        BEGIN,
        PATH,
        PARAMETER,
        END_CLAUSE,
        END;

    }
}

