/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.contribution.processor.DuplicateComposite;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.stream.Source;
import org.fabric3.model.type.component.Composite;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class CompositeResourceProcessor
implements ResourceProcessor {
    private Loader loader;
    private final XMLInputFactory xmlFactory;

    public CompositeResourceProcessor(@Reference ProcessorRegistry processorRegistry, @Reference Loader loader, @Reference XMLFactory xmlFactory) {
        processorRegistry.register((ResourceProcessor)this);
        this.loader = loader;
        this.xmlFactory = xmlFactory.newInputFactoryInstance();
    }

    public String getContentType() {
        return "text/vnd.fabric3.composite+xml";
    }

    public void index(Resource resource, IntrospectionContext context) throws InstallException {
        XMLStreamReader reader = null;
        InputStream stream = null;
        try {
            Source source = resource.getSource();
            stream = source.openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            reader.nextTag();
            String name = reader.getAttributeValue(null, "name");
            if (name == null) {
                context.addError((ValidationFailure)new MissingAttribute("Composite name not specified", reader));
                return;
            }
            String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
            QName compositeName = new QName(targetNamespace, name);
            QNameSymbol symbol = new QNameSymbol(compositeName);
            ResourceElement element = new ResourceElement((Symbol)symbol);
            resource.addResourceElement(element);
            this.validateUnique(resource, (ResourceElement<QNameSymbol, Composite>)element, reader, context);
        }
        catch (XMLStreamException e) {
            throw new InstallException((Throwable)e);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(Resource resource, IntrospectionContext context) throws InstallException {
        Composite composite;
        Source source = resource.getSource();
        ClassLoader classLoader = context.getClassLoader();
        URI contributionUri = context.getContributionUri();
        URL location = source.getBaseLocation();
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(contributionUri, classLoader, location);
        try {
            composite = (Composite)this.loader.load(source, Composite.class, (IntrospectionContext)childContext);
        }
        catch (LoaderException e) {
            throw new InstallException((Throwable)e);
        }
        boolean found = false;
        for (ResourceElement element : resource.getResourceElements()) {
            if (!element.getSymbol().getKey().equals(composite.getName())) continue;
            element.setValue((Object)composite);
            found = true;
            break;
        }
        if (!found) {
            String identifier = composite.getName().toString();
            throw new AssertionError((Object)("Resource element not found: " + identifier));
        }
        if (childContext.hasErrors()) {
            context.addErrors(childContext.getErrors());
        }
        if (childContext.hasWarnings()) {
            context.addWarnings(childContext.getWarnings());
        }
        resource.setState(ResourceState.PROCESSED);
    }

    private void validateUnique(Resource resource, ResourceElement<QNameSymbol, Composite> element, XMLStreamReader reader, IntrospectionContext context) {
        Contribution contribution = resource.getContribution();
        block0: for (Resource entry : contribution.getResources()) {
            if (!resource.getContentType().equals(entry.getContentType())) continue;
            for (ResourceElement elementEntry : entry.getResourceElements()) {
                if (!((QNameSymbol)element.getSymbol()).equals((Object)elementEntry.getSymbol())) continue;
                QName name = (QName)((QNameSymbol)element.getSymbol()).getKey();
                DuplicateComposite error = new DuplicateComposite("Duplicate composite found with name: " + name, reader);
                context.addError((ValidationFailure)error);
                continue block0;
            }
        }
    }
}

