/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionProcessor;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SymLinkContributionProcessor
implements ContributionProcessor {
    private ProcessorRegistry processorRegistry;

    public SymLinkContributionProcessor(@Reference ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Init
    public void init() {
        this.processorRegistry.register((ContributionProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.processorRegistry.unregister((ContributionProcessor)this);
    }

    public boolean canProcess(Contribution contribution) {
        String sourceUrl = contribution.getLocation().toString();
        return sourceUrl.endsWith(".contribution");
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        try {
            Contribution syntheticContribution = this.createSyntheticContribution(contribution);
            this.processorRegistry.processManifest(syntheticContribution, context);
            contribution.setManifest(syntheticContribution.getManifest());
            contribution.addMetaData((Object)contribution.getUri(), (Object)syntheticContribution);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
    }

    public void index(Contribution contribution, IntrospectionContext context) throws InstallException {
        Contribution syntheticContribution = (Contribution)contribution.getMetaData(Contribution.class, (Object)contribution.getUri());
        this.processorRegistry.indexContribution(syntheticContribution, context);
        for (Resource resource : syntheticContribution.getResources()) {
            resource.setContribution(contribution);
            contribution.addResource(resource);
        }
    }

    public void process(Contribution contribution, IntrospectionContext context) throws InstallException {
        Contribution syntheticContribution = (Contribution)contribution.getMetaData(Contribution.class, (Object)contribution.getUri());
        this.processorRegistry.processContribution(syntheticContribution, context);
        contribution.removeMetaData((Object)contribution.getUri());
    }

    private Contribution createSyntheticContribution(Contribution contribution) throws IOException {
        InputStreamReader streamReader = new InputStreamReader(contribution.getLocation().openStream());
        BufferedReader bufferedReader = new BufferedReader(streamReader);
        String line = bufferedReader.readLine().trim();
        File file = new File(line);
        URL url = file.toURI().toURL();
        URI contributionUri = URI.create(file.getName());
        UrlSource source = new UrlSource(url);
        long timestamp = System.currentTimeMillis();
        return new Contribution(contributionUri, (Source)source, url, timestamp, "text/vnd.fabric3.exploded", false);
    }
}

