/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.updater;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.CompositeImplementation;
import org.fabric3.model.type.component.Include;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceElementUpdater;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class CompositeResourceElementUpdater
implements ResourceElementUpdater<Composite> {
    public Set<ModelObject> update(Composite newComposite, Contribution contribution, Set<Contribution> dependentContributions) {
        HashSet<ModelObject> set = new HashSet<ModelObject>();
        this.updateComposite(newComposite, contribution, set);
        QName name = newComposite.getName();
        QNameSymbol symbol = new QNameSymbol(name);
        block0: for (Contribution dependent : dependentContributions) {
            for (ContributionWire wire : dependent.getWires()) {
                if (!wire.resolves((Symbol)symbol)) continue;
                this.updateComposite(newComposite, dependent, set);
                continue block0;
            }
        }
        return set;
    }

    public Set<ModelObject> remove(Composite composite, Contribution contribution, Set<Contribution> dependentContributions) {
        HashSet<ModelObject> set = new HashSet<ModelObject>();
        QName name = composite.getName();
        URI uri = composite.getContributionUri();
        Composite pointer = new Composite(name, true, uri);
        set.add((ModelObject)composite);
        this.removeComposite(contribution, name);
        this.replaceReferences(pointer, contribution, set);
        QNameSymbol symbol = new QNameSymbol(name);
        block0: for (Contribution dependent : dependentContributions) {
            for (ContributionWire wire : dependent.getWires()) {
                if (!wire.resolves((Symbol)symbol)) continue;
                this.replaceReferences(pointer, dependent, set);
                continue block0;
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeComposite(Contribution contribution, QName name) {
        List resources;
        List list = resources = contribution.getResources();
        synchronized (list) {
            for (Resource resource : resources) {
                for (ResourceElement element : resource.getResourceElements()) {
                    Composite candidate;
                    if (!(element.getValue() instanceof Composite) || !(candidate = (Composite)element.getValue()).getName().equals(name)) continue;
                    resources.remove(resource);
                    if (contribution.getLockOwners().contains(name)) {
                        contribution.releaseLock(name);
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComposite(Composite newComposite, Contribution contribution, Set<ModelObject> set) {
        List resources;
        QName name = newComposite.getName();
        boolean replaced = false;
        List list = resources = contribution.getResources();
        synchronized (list) {
            for (Resource resource : resources) {
                for (ResourceElement element : resource.getResourceElements()) {
                    Symbol symbol = element.getSymbol();
                    if (symbol instanceof QNameSymbol && ((QName)((QNameSymbol)symbol).getKey()).equals(name)) {
                        replaced = true;
                        element.setValue((Object)newComposite);
                        resource.setState(ResourceState.PROCESSED);
                        set.add((ModelObject)newComposite);
                        break;
                    }
                    if (!replaced) continue;
                    break;
                }
                if (!replaced) continue;
                break;
            }
            if (replaced) {
                this.replaceReferences(newComposite, contribution, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceReferences(Composite newComposite, Contribution contribution, Set<ModelObject> set) {
        List resources;
        List list = resources = contribution.getResources();
        synchronized (list) {
            for (Resource resource : resources) {
                for (ResourceElement element : resource.getResourceElements()) {
                    Object value = element.getValue();
                    if (!(value instanceof Composite)) continue;
                    Composite current = (Composite)value;
                    for (ComponentDefinition component : current.getDeclaredComponents().values()) {
                        CompositeImplementation implementation;
                        if (!(component.getImplementation() instanceof CompositeImplementation) || !((Composite)(implementation = (CompositeImplementation)component.getImplementation()).getComponentType()).getName().equals(newComposite.getName())) continue;
                        implementation.setComponentType((ComponentType)newComposite);
                        set.add((ModelObject)current);
                    }
                    for (Include include : current.getIncludes().values()) {
                        if (!newComposite.getName().equals(include.getIncluded().getName())) continue;
                        include.setIncluded(newComposite);
                        set.add((ModelObject)current);
                    }
                }
            }
        }
    }
}

