/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.coordinator;

import java.util.LinkedList;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.coordinator.DeploymentCache;
import org.oasisopen.sca.annotation.Property;

public class DeploymentCacheImpl
implements DeploymentCache {
    private LinkedList<DeploymentCommand> history = new LinkedList();
    private int threshold = 3;

    public synchronized void cache(DeploymentCommand command) {
        if (this.history.size() >= this.threshold) {
            this.history.removeFirst();
        }
        this.history.add(command);
    }

    @Property(required=false)
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public synchronized DeploymentCommand undo() {
        if (this.history.isEmpty()) {
            return null;
        }
        return this.history.removeLast();
    }

    public synchronized DeploymentCommand get() {
        if (this.history.isEmpty()) {
            return null;
        }
        return this.history.getLast();
    }
}

