/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.coordinator;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.management.OperationType;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.coordinator.DeploymentCache;
import org.fabric3.federation.deployment.coordinator.RollbackException;
import org.fabric3.federation.deployment.coordinator.RollbackService;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Management(name="RollbackService", path="/runtime/deployment/rollback", group="deployment", description="Performs deployment rollback operations")
public class RollbackServiceImpl
implements RollbackService {
    private DeploymentCache cache;
    private CommandExecutorRegistry executorRegistry;
    private ScopeRegistry scopeRegistry;
    private SerializationService serializationService;

    public RollbackServiceImpl(@Reference CommandExecutorRegistry executorRegistry, @Reference DeploymentCache cache, @Reference ScopeRegistry scopeRegistry, @Reference SerializationService serializationService) {
        this.executorRegistry = executorRegistry;
        this.cache = cache;
        this.scopeRegistry = scopeRegistry;
        this.serializationService = serializationService;
    }

    @Override
    @ManagementOperation(path="/", type=OperationType.POST, description="Rollbacks the previous deployment")
    public void rollback() throws RollbackException {
        DeploymentCommand command = this.cache.undo();
        if (command == null) {
            return;
        }
        byte[] serializedCommands = command.getCurrentDeploymentUnit().getCommands();
        try {
            List commands = (List)this.serializationService.deserialize(List.class, serializedCommands);
            this.rollback(commands, commands.size());
        }
        catch (ClassNotFoundException e) {
            throw new RollbackException(e);
        }
        catch (IOException e) {
            throw new RollbackException(e);
        }
    }

    @Override
    public void rollback(List<CompensatableCommand> commands, int marker) throws RollbackException {
        try {
            ListIterator<CompensatableCommand> iter = commands.listIterator(marker);
            while (iter.hasPrevious()) {
                CompensatableCommand command = iter.previous();
                CompensatableCommand compensating = command.getCompensatingCommand();
                this.executorRegistry.execute((Command)compensating);
            }
            if (this.scopeRegistry != null) {
                this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
            }
        }
        catch (ExecutionException e) {
            throw new RollbackException(e);
        }
        catch (InstanceLifecycleException e) {
            throw new RollbackException(e);
        }
    }
}

