/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.domain;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.SerializedDeploymentUnit;
import org.fabric3.federation.deployment.spi.FederatedDeployerListener;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.DeployerMonitor;
import org.fabric3.spi.domain.DeploymentPackage;
import org.fabric3.spi.federation.DomainTopologyService;
import org.fabric3.spi.federation.ErrorResponse;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.Zone;
import org.fabric3.spi.generator.Deployment;
import org.fabric3.spi.generator.DeploymentUnit;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class FederatedDeployer
implements Deployer {
    private DeployerMonitor monitor;
    private DomainTopologyService topologyService;
    private SerializationService serializationService;
    private List<FederatedDeployerListener> listeners;
    private long timeout = 60000L;

    public FederatedDeployer(@Reference DomainTopologyService topologyService, @Reference SerializationService serializationService, @Monitor DeployerMonitor monitor) {
        this.topologyService = topologyService;
        this.serializationService = serializationService;
        this.monitor = monitor;
        this.listeners = new ArrayList<FederatedDeployerListener>();
    }

    @Reference(required=false)
    public void setListeners(List<FederatedDeployerListener> listeners) {
        this.listeners = listeners;
    }

    @Property(required=false)
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void deploy(DeploymentPackage deploymentPackage) throws DeploymentException {
        Deployment currentDeployment = deploymentPackage.getCurrentDeployment();
        Deployment fullDeployment = deploymentPackage.getFullDeployment();
        ArrayList<DeploymentCommand> completed = new ArrayList<DeploymentCommand>();
        for (String zoneName : currentDeployment.getZones()) {
            DeploymentCommand command;
            this.monitor.deploy(zoneName);
            try {
                command = this.createCommand(zoneName, currentDeployment, fullDeployment);
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
            this.notifyDeploy(command);
            Zone zone = new Zone(zoneName, Collections.emptyList());
            if (!this.topologyService.getZones().contains(zone)) {
                this.monitor.participantNotAvailable(zoneName);
            } else {
                List responses;
                try {
                    responses = this.topologyService.sendSynchronousToZone(zoneName, (ResponseCommand)command, true, this.timeout);
                }
                catch (MessageException e) {
                    throw new DeploymentException((Throwable)e);
                }
                if (responses.isEmpty()) {
                    throw new DeploymentException("Deployment responses not received");
                }
                Response last = (Response)responses.get(responses.size() - 1);
                String runtimeName = last.getRuntimeName();
                if (last instanceof ErrorResponse) {
                    ErrorResponse response = (ErrorResponse)last;
                    this.monitor.deploymentError(runtimeName, (Throwable)response.getException());
                    throw new DeploymentException("Deployment errors encountered and logged");
                }
            }
            completed.add(command);
        }
        for (DeploymentCommand command : completed) {
            this.notifyCompletion(command);
        }
    }

    private DeploymentCommand createCommand(String zone, Deployment currentDeployment, Deployment fullDeployment) throws IOException {
        DeploymentUnit currentDeploymentUnit = currentDeployment.getDeploymentUnit(zone);
        SerializedDeploymentUnit currentSerializedUnit = this.createSerializedUnit(currentDeploymentUnit);
        DeploymentUnit fullDeploymentUnit = fullDeployment.getDeploymentUnit(zone);
        SerializedDeploymentUnit fullSerializedUnit = this.createSerializedUnit(fullDeploymentUnit);
        return new DeploymentCommand(zone, currentSerializedUnit, fullSerializedUnit);
    }

    private SerializedDeploymentUnit createSerializedUnit(DeploymentUnit deploymentUnit) throws IOException {
        List provisionCommands = deploymentUnit.getProvisionCommands();
        byte[] serializedProvisionCommands = this.serializationService.serialize((Serializable)((Object)provisionCommands));
        List extensionCommands = deploymentUnit.getExtensionCommands();
        byte[] serializedExtensionCommands = this.serializationService.serialize((Serializable)((Object)extensionCommands));
        List commands = deploymentUnit.getCommands();
        byte[] serializedCommands = this.serializationService.serialize((Serializable)((Object)commands));
        return new SerializedDeploymentUnit(serializedProvisionCommands, serializedExtensionCommands, serializedCommands);
    }

    private void notifyDeploy(DeploymentCommand command) throws DeploymentException {
        for (FederatedDeployerListener listener : this.listeners) {
            listener.onDeploy(command);
        }
    }

    private void notifyCompletion(DeploymentCommand command) {
        for (FederatedDeployerListener listener : this.listeners) {
            listener.onCompletion(command);
        }
    }
}

