/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.executor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateResponse;
import org.fabric3.federation.deployment.command.SerializedDeploymentUnit;
import org.fabric3.federation.deployment.executor.RuntimeUpdateMonitor;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.spi.classloader.MultiClassLoaderObjectOutputStream;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.generator.Deployment;
import org.fabric3.spi.generator.DeploymentUnit;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.Generator;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ControllerRuntimeUpdateCommandExecutor
implements CommandExecutor<RuntimeUpdateCommand> {
    private CommandExecutorRegistry executorRegistry;
    private RuntimeUpdateMonitor monitor;
    private LogicalComponentManager lcm;
    private Generator generator;

    public ControllerRuntimeUpdateCommandExecutor(@Reference(name="lcm") LogicalComponentManager lcm, @Reference(name="generator") Generator generator, @Reference CommandExecutorRegistry executorRegistry, @Monitor RuntimeUpdateMonitor monitor) {
        this.lcm = lcm;
        this.generator = generator;
        this.executorRegistry = executorRegistry;
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.executorRegistry.register(RuntimeUpdateCommand.class, (CommandExecutor)this);
    }

    public void execute(RuntimeUpdateCommand command) throws ExecutionException {
        try {
            String runtimeName = command.getRuntimeName();
            this.monitor.updateRequest(runtimeName);
            String zone = command.getZoneName();
            DeploymentUnit unit = this.regenerate(zone);
            List provisionCommands = unit.getProvisionCommands();
            byte[] serializedProvisionCommands = this.serialize((Serializable)((Object)provisionCommands));
            List extensionCommands = unit.getExtensionCommands();
            byte[] serializedExtensionCommands = this.serialize((Serializable)((Object)extensionCommands));
            List commands = unit.getCommands();
            byte[] serializedCommands = this.serialize((Serializable)((Object)commands));
            SerializedDeploymentUnit serializedUnit = new SerializedDeploymentUnit(serializedProvisionCommands, serializedExtensionCommands, serializedCommands);
            DeploymentCommand deploymentCommand = new DeploymentCommand(zone, serializedUnit, serializedUnit);
            RuntimeUpdateResponse response = new RuntimeUpdateResponse(deploymentCommand);
            command.setResponse(response);
            this.monitor.sendingUpdate(runtimeName);
        }
        catch (DeploymentException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private DeploymentUnit regenerate(String zoneId) throws DeploymentException {
        LogicalCompositeComponent domain = this.lcm.getRootComponent();
        try {
            Deployment deployment = this.generator.generate(domain, false);
            return deployment.getDeploymentUnit(zoneId);
        }
        catch (GenerationException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private byte[] serialize(Serializable serializable) throws ExecutionException {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            MultiClassLoaderObjectOutputStream stream = new MultiClassLoaderObjectOutputStream((OutputStream)bas);
            stream.writeObject((Object)serializable);
            return bas.toByteArray();
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

