/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.executor;

import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateResponse;
import org.fabric3.federation.deployment.coordinator.DeploymentCache;
import org.fabric3.federation.deployment.executor.RuntimeUpdateMonitor;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class RuntimeUpdateCommandExecutor
implements CommandExecutor<RuntimeUpdateCommand> {
    private DeploymentCache cache;
    private CommandExecutorRegistry executorRegistry;
    private RuntimeUpdateMonitor monitor;

    public RuntimeUpdateCommandExecutor(@Reference DeploymentCache cache, @Reference CommandExecutorRegistry executorRegistry, @Monitor RuntimeUpdateMonitor monitor) {
        this.cache = cache;
        this.executorRegistry = executorRegistry;
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.executorRegistry.register(RuntimeUpdateCommand.class, (CommandExecutor)this);
    }

    public void execute(RuntimeUpdateCommand command) throws ExecutionException {
        RuntimeUpdateResponse response;
        String runtime = command.getRuntimeName();
        this.monitor.updateRequest(runtime);
        DeploymentCommand deploymentCommand = this.cache.get();
        if (deploymentCommand == null) {
            this.monitor.notUpdated(runtime);
            response = new RuntimeUpdateResponse();
        } else {
            this.monitor.sendingUpdate(runtime);
            response = new RuntimeUpdateResponse(deploymentCommand);
        }
        command.setResponse(response);
    }
}

