/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.timer.component.introspection;

import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.IntrospectionContext;
import org.fabric3.introspection.xml.LoaderHelper;
import org.fabric3.introspection.xml.LoaderUtil;
import org.fabric3.introspection.xml.MissingAttribute;
import org.fabric3.introspection.xml.TypeLoader;
import org.fabric3.java.introspection.ImplementationArtifactNotFound;
import org.fabric3.java.introspection.JavaImplementationProcessor;
import org.fabric3.java.scdl.JavaImplementation;
import org.fabric3.pojo.scdl.PojoComponentType;
import org.fabric3.scdl.AbstractComponentType;
import org.fabric3.scdl.Implementation;
import org.fabric3.scdl.PolicyAware;
import org.fabric3.timer.component.introspection.CronExpression;
import org.fabric3.timer.component.introspection.InvalidInterface;
import org.fabric3.timer.component.introspection.InvalidTimerExpression;
import org.fabric3.timer.component.provision.TriggerData;
import org.fabric3.timer.component.provision.TriggerType;
import org.fabric3.timer.component.scdl.TimerImplementation;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerImplementationLoader
implements TypeLoader<TimerImplementation> {
    private final JavaImplementationProcessor implementationProcessor;
    private final LoaderHelper loaderHelper;

    public TimerImplementationLoader(@Reference JavaImplementationProcessor implementationProcessor, @Reference LoaderHelper loaderHelper) {
        this.implementationProcessor = implementationProcessor;
        this.loaderHelper = loaderHelper;
    }

    public TimerImplementation load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        assert (TimerImplementation.IMPLEMENTATION_TIMER.equals(reader.getName()));
        TimerImplementation implementation = new TimerImplementation();
        if (!this.processImplementationClass(implementation, reader, context)) {
            PojoComponentType type = new PojoComponentType();
            implementation.setComponentType((AbstractComponentType)type);
            return implementation;
        }
        TriggerData data = new TriggerData();
        implementation.setTriggerData(data);
        this.processCronExpression(reader, context, data);
        this.processRepeatInterval(reader, context, data);
        this.processRepeatFixedRate(reader, context, data);
        this.processFireOnce(reader, context, data);
        this.validateFireData(reader, context, data);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)implementation, reader, context);
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        this.implementationProcessor.introspect((Implementation)implementation, context);
        return implementation;
    }

    private void validateFireData(XMLStreamReader reader, IntrospectionContext context, TriggerData data) {
        if (data.getCronExpression() == null && data.getFixedRate() == -1L && data.getRepeatInterval() == -1L && data.getFireOnce() == -1L) {
            MissingAttribute failure = new MissingAttribute("A cron expression, fixed rate, repeat interval, or fire once time must be specified on the timer component", null, reader);
            context.addError((ValidationFailure)failure);
        }
    }

    private boolean processImplementationClass(TimerImplementation implementation, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("The class attribute was not specified", "class", reader);
            context.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return false;
        }
        implementation.setImplementationClass(implClass);
        try {
            Class<?> clazz = context.getTargetClassLoader().loadClass(implClass);
            if (!Runnable.class.isAssignableFrom(clazz)) {
                InvalidInterface failure = new InvalidInterface(implementation);
                context.addError((ValidationFailure)failure);
                LoaderUtil.skipToEndElement((XMLStreamReader)reader);
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            ImplementationArtifactNotFound failure = new ImplementationArtifactNotFound((JavaImplementation)implementation, e.getMessage());
            context.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return false;
        }
        return true;
    }

    private void processCronExpression(XMLStreamReader reader, IntrospectionContext introspectionContext, TriggerData data) {
        String cronExpression = reader.getAttributeValue(null, "cronExpression");
        if (cronExpression != null) {
            try {
                new CronExpression(cronExpression);
                data.setType(TriggerType.CRON);
                data.setCronExpression(cronExpression);
            }
            catch (ParseException e) {
                InvalidTimerExpression failure = new InvalidTimerExpression("Cron expression is invalid: " + cronExpression, cronExpression, reader, e);
                introspectionContext.addError((ValidationFailure)failure);
            }
        }
    }

    private void processRepeatInterval(XMLStreamReader reader, IntrospectionContext introspectionContext, TriggerData data) {
        String repeatInterval = reader.getAttributeValue(null, "repeatInterval");
        if (repeatInterval != null) {
            if (data.getCronExpression() != null) {
                InvalidTimerExpression failure = new InvalidTimerExpression("Cron expression and repeat interval both specified", reader);
                introspectionContext.addError((ValidationFailure)failure);
            }
            try {
                long repeat = Long.parseLong(repeatInterval);
                data.setType(TriggerType.INTERVAL);
                data.setRepeatInterval(repeat);
            }
            catch (NumberFormatException e) {
                InvalidTimerExpression failure = new InvalidTimerExpression("Repeat interval is invalid: " + repeatInterval, repeatInterval, reader, e);
                introspectionContext.addError((ValidationFailure)failure);
            }
        }
    }

    private void processRepeatFixedRate(XMLStreamReader reader, IntrospectionContext introspectionContext, TriggerData data) {
        String fixedRate = reader.getAttributeValue(null, "fixedRate");
        if (fixedRate != null) {
            InvalidTimerExpression failure;
            if (data.getCronExpression() != null) {
                failure = new InvalidTimerExpression("Cron expression and fixed rate both specified", reader);
                introspectionContext.addError((ValidationFailure)failure);
            }
            if (data.getRepeatInterval() != -1L) {
                failure = new InvalidTimerExpression("Repeat interval and fixed rate both specified", reader);
                introspectionContext.addError((ValidationFailure)failure);
            }
            try {
                long rate = Long.parseLong(fixedRate);
                data.setType(TriggerType.FIXED_RATE);
                data.setFixedRate(rate);
            }
            catch (NumberFormatException e) {
                InvalidTimerExpression failure2 = new InvalidTimerExpression("Fixed rate interval is invalid: " + fixedRate, fixedRate, reader, e);
                introspectionContext.addError((ValidationFailure)failure2);
            }
        }
    }

    private void processFireOnce(XMLStreamReader reader, IntrospectionContext introspectionContext, TriggerData data) {
        String time = reader.getAttributeValue(null, "fireOnce");
        if (time != null) {
            InvalidTimerExpression failure;
            if (data.getCronExpression() != null) {
                failure = new InvalidTimerExpression("Cron expression and fire once both specified", reader);
                introspectionContext.addError((ValidationFailure)failure);
            }
            if (data.getRepeatInterval() != -1L) {
                failure = new InvalidTimerExpression("Repeat interval and fire once both specified", reader);
                introspectionContext.addError((ValidationFailure)failure);
            }
            if (data.getFixedRate() != -1L) {
                failure = new InvalidTimerExpression("Ficed rate and fire once both specified", reader);
                introspectionContext.addError((ValidationFailure)failure);
            }
            try {
                long rate = Long.parseLong(time);
                data.setType(TriggerType.ONCE);
                data.setFireOnce(rate);
            }
            catch (NumberFormatException e) {
                InvalidTimerExpression failure2 = new InvalidTimerExpression("Fire once time is invalid: " + time, time, reader, e);
                introspectionContext.addError((ValidationFailure)failure2);
            }
        }
    }
}

