/*
 * Copyright 2009 Grepo Committers.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.grepo.query.hibernate.validator;

import java.io.IOException;

import org.codehaus.grepo.core.validator.TestResultValidator;
import org.codehaus.grepo.query.commons.annotation.GenericQuery;
import org.codehaus.grepo.query.commons.repository.GenericRepository;
import org.codehaus.grepo.query.hibernate.TestEntity;

/**
 * @author dguggi
 */
public interface ValidatorTestRepository extends GenericRepository<TestEntity> {
    /**
     * @param username The username.
     * @return Returns the entity.
     */
    @GenericQuery(resultValidator = TestResultValidator.class)
    TestEntity getByUsername(String username);

    /**
     * @param username The username.
     * @return Returns the test entity.
     * @throws IOException in case of errors.
     */
    @GenericQuery(resultValidator = TestResultValidator.class,
        queryName = "org.codehaus.grepo.query.hibernate.TestEntity.ByUsername")
    TestEntity getByUsernameThrowsIOException(String username) throws IOException;
}
