/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CacheItemTest {
    private CacheItem item;
    private DateTime storageTime = new DateTime(2008, 10, 12, 15, 0, 0, 0);
    private DateTime now = this.storageTime.plusMinutes(1);

    @Before
    public void before() {
        DateTimeUtils.setCurrentMillisFixed((long)this.now.getMillis());
    }

    public void setupItem(Headers headers) {
        this.item = new CacheItem(new HTTPResponse(null, Status.OK, headers), this.storageTime);
    }

    @Test
    public void testIsNotStale() {
        Headers headers = this.createDefaultHeaders().add(new Header("Cache-Control", "private, max-age=3600"));
        this.setupItem(headers);
        Assert.assertFalse((String)"Item was stale", (boolean)this.item.isStale());
        this.item = new CacheItem(this.item.getResponse());
        DateTimeUtils.setCurrentMillisFixed((long)this.now.plusSeconds(3600).getMillis());
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale());
    }

    private Headers createDefaultHeaders() {
        return new Headers().add(HeaderUtils.toHttpDate((String)"Date", (DateTime)new DateTime()));
    }

    @Test
    public void testIsStale() {
        Headers headers = this.createDefaultHeaders().add(new Header("Cache-Control", "private, max-age=60"));
        this.setupItem(headers);
        DateTimeUtils.setCurrentMillisFixed((long)this.now.plusMinutes(1).getMillis());
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale());
    }

    @Test
    public void testIsStaleExpiresHeader() {
        Headers headers = this.createDefaultHeaders().add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)this.now));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale());
    }

    @Test
    public void testIsNotStaleExpiresHeader() {
        Headers headers = this.createDefaultHeaders();
        DateTime future = new DateTime((Object)this.now);
        future = future.plusHours(1);
        headers = headers.add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)future));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was stale", (!this.item.isStale() ? 1 : 0) != 0);
    }

    @Test
    public void testIsStaleEqualToDateHeader() {
        Headers headers = new Headers();
        DateTime future = new DateTime((Object)this.now);
        future = future.plusHours(1);
        headers = headers.add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)future));
        headers = headers.add(HeaderUtils.toHttpDate((String)"Date", (DateTime)future));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was stale", (boolean)this.item.isStale());
    }

    public void testIsStaleExpiresHeaderWithInvalidDate() {
        Headers headers = new Headers().add(new Header("Expires", "foo"));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was stale", (boolean)this.item.isStale());
    }

    @Test
    public void testIsStaleExpiresHeaderWithCacheControl() {
        Headers headers = this.createDefaultHeaders();
        headers = headers.add(new Header("Cache-Control", "private, max-age=60"));
        DateTime future = new DateTime((Object)this.now);
        future = future.plusHours(24);
        headers = headers.add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)future));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale());
    }
}

