/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.net.URI;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.cache.CacheStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class CacheStorageAbstractTest {
    protected CacheStorage storage;
    protected static final HTTPRequest REQUEST = new HTTPRequest(URI.create("foo"));

    @Before
    public void setup() {
        this.storage = this.createCacheStorage();
    }

    protected abstract CacheStorage createCacheStorage();

    protected abstract void afterTest();

    @After
    public void after() {
        if (this.storage != null) {
            this.storage.clear();
        }
        this.afterTest();
    }

    @Test
    public void testPutCacheItem() {
        HTTPResponse response = new HTTPResponse(null, Status.OK, new Headers());
        this.storage.insert(REQUEST, response);
        junit.framework.Assert.assertEquals((int)1, (int)this.storage.size());
    }

    @Test
    public void testPutAndGetCacheItem() {
        CacheItem outItem = this.putAndGet((HTTPRequest)Mockito.mock(HTTPRequest.class));
        Assert.assertNotNull((String)"OutItem was null", (Object)outItem);
        Assert.assertNotNull((String)"OutItem response was null", (Object)outItem.getResponse());
    }

    private CacheItem putAndGet(HTTPRequest request) {
        HTTPResponse response = new HTTPResponse(null, Status.OK, new Headers());
        URI requestURI = URI.create("foo");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestURI);
        this.storage.insert(REQUEST, response);
        junit.framework.Assert.assertEquals((int)1, (int)this.storage.size());
        return this.storage.get(request);
    }

    @Test
    public void testPutUpdatedCacheItem() {
        HTTPRequest request = (HTTPRequest)Mockito.mock(HTTPRequest.class);
        CacheItem item = this.putAndGet(request);
        URI requestURI = URI.create("foo");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestURI);
        HTTPResponse response = new HTTPResponse(null, Status.OK, new Headers());
        this.storage.update(REQUEST, response);
        CacheItem cacheItem = this.storage.get(request);
        junit.framework.Assert.assertNotSame((String)"Items were the same", (Object)cacheItem.getCachedTime(), (Object)item.getCachedTime());
    }

    @Test
    public void testInvalidate() {
        HTTPResponse response = new HTTPResponse(null, Status.OK, new Headers());
        URI requestURI = URI.create("foo");
        this.storage.insert(REQUEST, response);
        junit.framework.Assert.assertEquals((int)1, (int)this.storage.size());
        this.storage.invalidate(requestURI);
        junit.framework.Assert.assertEquals((int)0, (int)this.storage.size());
    }
}

