/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.cache.CacheStorage;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ConcurrentCacheStorageAbstractTest {
    private ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    protected CacheStorage cacheStorage;

    @Before
    public void setUp() {
        this.cacheStorage = this.createCacheStorage();
    }

    protected abstract CacheStorage createCacheStorage();

    @Test
    public void test100Concurrent() throws InterruptedException {
        this.testIterations(100, 100);
    }

    protected void testIterations(int numberOfIterations, int expected) throws InterruptedException {
        ArrayList<1> calls = new ArrayList<1>();
        for (int i = 0; i < numberOfIterations; ++i) {
            URI uri = URI.create(String.valueOf(i));
            final HTTPRequest request = new HTTPRequest(uri);
            Callable<HTTPResponse> call = new Callable<HTTPResponse>(){

                @Override
                public HTTPResponse call() throws Exception {
                    HTTPResponse cached = ConcurrentCacheStorageAbstractTest.this.cacheStorage.insert(request, ConcurrentCacheStorageAbstractTest.this.createCacheResponse());
                    ConcurrentCacheStorageAbstractTest.this.assertResponse(cached);
                    CacheItem cacheItem = ConcurrentCacheStorageAbstractTest.this.cacheStorage.get(request);
                    HTTPResponse response = cacheItem.getResponse();
                    ConcurrentCacheStorageAbstractTest.this.assertResponse(response);
                    cached = ConcurrentCacheStorageAbstractTest.this.cacheStorage.insert(request, ConcurrentCacheStorageAbstractTest.this.createCacheResponse());
                    Assert.assertNotSame((Object)cached, (Object)cacheItem.getResponse());
                    ConcurrentCacheStorageAbstractTest.this.assertResponse(cached);
                    return cached;
                }
            };
            calls.add(call);
        }
        List responses = this.service.invokeAll(calls);
        for (Future response : responses) {
            try {
                response.get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Assert.fail((String)e.getCause().getMessage());
            }
        }
        Assert.assertEquals((long)expected, (long)this.cacheStorage.size());
    }

    @Test
    public void test1000InsertsOfSameURI() throws InterruptedException {
        final HTTPRequest request = new HTTPRequest(URI.create("GET"));
        ArrayList<2> calls = new ArrayList<2>();
        for (int i = 0; i < 1000; ++i) {
            calls.add(new Callable<HTTPResponse>(){

                @Override
                public HTTPResponse call() throws Exception {
                    return ConcurrentCacheStorageAbstractTest.this.cacheStorage.insert(request, ConcurrentCacheStorageAbstractTest.this.createCacheResponse());
                }
            });
        }
        List responses = this.service.invokeAll(calls);
        for (Future response : responses) {
            try {
                HTTPResponse real = (HTTPResponse)response.get();
                this.assertResponse(real);
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.getCause().getMessage());
            }
        }
        Assert.assertEquals((long)1L, (long)this.cacheStorage.size());
    }

    private HTTPResponse createCacheResponse() {
        return new HTTPResponse((Payload)new InputStreamPayload((InputStream)new NullInputStream(40L), MIMEType.APPLICATION_OCTET_STREAM), Status.OK, new Headers().add("Foo", "Bar"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertResponse(HTTPResponse response) {
        Assert.assertNotNull((String)"Response was null", (Object)response);
        Assert.assertTrue((String)"Payload was not here", (boolean)response.hasPayload());
        Assert.assertTrue((String)"Payload was not available", (boolean)response.getPayload().isAvailable());
        InputStream is = response.getPayload().getInputStream();
        try {
            IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"unable to write string from stream");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @After
    public void tearDown() {
        if (this.cacheStorage != null) {
            this.cacheStorage.clear();
        }
        this.service.shutdownNow();
    }
}

