/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.input.NullInputStream;
import org.codehaus.httpcache4j.cache.FileManager;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.cache.Vary;
import org.codehaus.httpcache4j.util.DeletingFileFilter;
import org.codehaus.httpcache4j.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileManagerTest {
    private FileManager fileManager;
    private File testFile;

    @Before
    public void setUp() {
        this.testFile = TestUtil.getTestFile((String)"target/test");
        this.fileManager = new FileManager(this.testFile);
    }

    @Test
    public void testResolveToFile() throws IOException {
        File file = this.fileManager.createFile(Key.create((URI)URI.create("foo"), (Vary)new Vary()), (InputStream)new NullInputStream(1L));
        Assert.assertNotNull((String)"File was null", (Object)file);
        Assert.assertEquals((long)1L, (long)file.length());
    }

    public void testResolveToEmptyFile() throws IOException {
        File file = this.fileManager.createFile(Key.create((URI)URI.create("foo"), (Vary)new Vary()), (InputStream)new NullInputStream(0L));
        Assert.assertNull((String)"File was not null", (Object)file);
    }

    @After
    public void tearDown() {
        this.testFile.listFiles((FileFilter)new DeletingFileFilter());
    }
}

