/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TTLTest {
    private int DEFAULT_TTL = 10;
    private DateTime storageTime;
    private DateTime dateTime = this.storageTime = new DateTime(2008, 10, 12, 15, 0, 0, 0);
    private DateTime now = new DateTime(2008, 10, 12, 15, 10, 0, 0);

    @Before
    public void before() {
        DateTimeUtils.setCurrentMillisFixed((long)this.now.getMillis());
    }

    @Test
    public void testDefaultTTL() {
        long ttl = CacheItem.getTTL((HTTPResponse)new HTTPResponse(null, Status.OK, this.createDefaultHeaders()), (int)this.DEFAULT_TTL);
        Assert.assertEquals((long)this.DEFAULT_TTL, (long)ttl);
    }

    @Test
    public void testDefaultTTLWith0MaxAge() {
        long ttl = CacheItem.getTTL((HTTPResponse)new HTTPResponse(null, Status.OK, this.createDefaultHeaders().add("Cache-Control", "max-age=0")), (int)this.DEFAULT_TTL);
        Assert.assertEquals((long)this.DEFAULT_TTL, (long)ttl);
    }

    @Test
    public void test100MaxAge() {
        long ttl = CacheItem.getTTL((HTTPResponse)new HTTPResponse(null, Status.OK, this.createDefaultHeaders().add("Cache-Control", "max-age=100")), (int)this.DEFAULT_TTL);
        Assert.assertEquals((long)100L, (long)ttl);
    }

    @Test
    public void testDefaultTTLWith10MaxAgeAndExpires() {
        DateTime expires = this.now.plus((ReadablePeriod)Years.years((int)1));
        Headers headers = this.createDefaultHeaders().add("Cache-Control", "max-age=10").add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)expires));
        long ttl = CacheItem.getTTL((HTTPResponse)new HTTPResponse(null, Status.OK, headers), (int)this.DEFAULT_TTL);
        Assert.assertEquals((long)this.DEFAULT_TTL, (long)ttl);
    }

    @Test
    public void testDefaultTTLExpires() {
        DateTime expires = this.now.plus((ReadablePeriod)Years.years((int)1));
        Headers headers = this.createDefaultHeaders().add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)expires));
        long ttl = CacheItem.getTTL((HTTPResponse)new HTTPResponse(null, Status.OK, headers), (int)this.DEFAULT_TTL);
        Assert.assertEquals((long)31536600L, (long)ttl);
    }

    private Headers createDefaultHeaders() {
        return new Headers().add(HeaderUtils.toHttpDate((String)"Date", (DateTime)this.dateTime));
    }
}

