/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.cache.FileResolver;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.cache.Vary;
import org.codehaus.httpcache4j.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class VaryTest {
    private Vary vary;

    @Test
    public void testIsEmpty() {
        this.vary = new Vary();
        Assert.assertTrue((String)"Header names added", (boolean)this.vary.isEmpty());
        this.vary = new Vary(new HashMap());
        Assert.assertTrue((String)"Header names added", (boolean)this.vary.isEmpty());
    }

    @Test
    public void testHasOne() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Accept-Language", "en");
        this.vary = new Vary(map);
        Assert.assertFalse((String)"Header names added", (boolean)this.vary.isEmpty());
        Assert.assertEquals((String)"Header names added", (long)1L, (long)this.vary.size());
    }

    @Test
    public void testHasMultiple() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Accept-Language", "en");
        map.put("Accept-Encoding", "gz");
        map.put("Accept-Charset", "UTF-8");
        this.vary = new Vary(map);
        Assert.assertFalse((String)"Header names added", (boolean)this.vary.isEmpty());
        Assert.assertEquals((String)"Header names added", (long)3L, (long)this.vary.size());
    }

    @Test
    public void testDoesNotMatchRequest() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Accept-Language", "en");
        map.put("Accept-Encoding", "gz");
        map.put("Accept-Charset", "UTF-8");
        this.vary = new Vary(map);
        Assert.assertFalse((String)"Header names added", (boolean)this.vary.isEmpty());
        Assert.assertEquals((String)"Header names added", (long)3L, (long)this.vary.size());
        HTTPRequest request = new HTTPRequest(URI.create("no.uri"));
        Assert.assertFalse((boolean)this.vary.matches(request));
    }

    @Test
    public void testDoesMatchesRequest() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Accept-Language", "en");
        map.put("Accept-Encoding", "gz");
        map.put("Accept-Charset", "UTF-8");
        this.vary = new Vary(map);
        Assert.assertFalse((String)"Header names added", (boolean)this.vary.isEmpty());
        Assert.assertEquals((String)"Header names added", (long)3L, (long)this.vary.size());
        HTTPRequest request = new HTTPRequest(URI.create("no.uri"));
        for (Map.Entry header : map.entrySet()) {
            request = request.addHeader((String)header.getKey(), (String)header.getValue());
        }
        Assert.assertTrue((boolean)this.vary.matches(request));
    }

    @Test
    public void testAlmostMatchesRequest() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Accept-Language", "en");
        map.put("Accept-Encoding", "gz");
        map.put("Accept-Charset", "UTF-8");
        this.vary = new Vary(map);
        Assert.assertFalse((String)"Header names added", (boolean)this.vary.isEmpty());
        Assert.assertEquals((String)"Header names added", (long)3L, (long)this.vary.size());
        HTTPRequest request = new HTTPRequest(URI.create("no.uri"));
        request = request.addHeader("Accept-Language", "de");
        request = request.addHeader("Accept-Encoding", "gz");
        request = request.addHeader("Accept-Charset", "UTF-8");
        Assert.assertFalse((boolean)this.vary.matches(request));
    }

    @Test
    public void testVaryFileResolve() {
        FileResolver resolver = new FileResolver(TestUtil.getTestFile((String)"target"));
        File file = resolver.resolve(Key.create((URI)URI.create("foo"), (Vary)new Vary()));
        File file2 = resolver.resolve(Key.create((URI)URI.create("foo"), (Vary)new Vary()));
        File file3 = resolver.resolve(Key.create((URI)URI.create("foo"), (Vary)new Vary(new HashMap())));
        File file4 = resolver.resolve(Key.create((URI)URI.create("foo"), (Vary)new Vary(Collections.singletonMap("Accept-Language", "en"))));
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)file2.getAbsolutePath());
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)file3.getAbsolutePath());
        Assert.assertEquals((Object)file2.getAbsolutePath(), (Object)file3.getAbsolutePath());
        Assert.assertEquals((Object)file2.getAbsolutePath(), (Object)file3.getAbsolutePath());
        Assert.assertFalse((boolean)file4.getAbsolutePath().equals(file3.getAbsolutePath()));
    }
}

