/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.net.URI;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.cache.DefaultCacheItem;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadableDuration;
import org.joda.time.Seconds;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CacheItemTest {
    private CacheItem item;
    private DateTime storageTime = new DateTime(2008, 10, 12, 15, 0, 0, 0);
    private DateTime now = this.storageTime.plusMinutes(1);
    private HTTPRequest request;

    @Before
    public void before() {
        DateTimeUtils.setCurrentMillisFixed((long)this.now.getMillis());
        this.request = new HTTPRequest(URI.create("foo"));
    }

    public void setupItem(Headers headers) {
        this.item = new DefaultCacheItem(new HTTPResponse(null, Status.OK, headers), this.storageTime);
    }

    @Test
    public void testIsNotStale() {
        Headers headers = this.createDefaultHeaders().add(new Header("Cache-Control", "private, max-age=3600"));
        this.setupItem(headers);
        Assert.assertFalse((String)"Item was stale", (boolean)this.item.isStale(this.request));
        this.item = new DefaultCacheItem(this.item.getResponse());
        DateTimeUtils.setCurrentMillisFixed((long)this.now.plusSeconds(3600).getMillis());
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale(new HTTPRequest(this.request.getRequestURI())));
    }

    private Headers createDefaultHeaders() {
        return new Headers().add(HeaderUtils.toHttpDate((String)"Date", (DateTime)new DateTime()));
    }

    @Test
    public void testIsStale() {
        Headers headers = this.createDefaultHeaders().add(new Header("Cache-Control", "private, max-age=60"));
        this.setupItem(headers);
        DateTimeUtils.setCurrentMillisFixed((long)this.now.plusMinutes(1).getMillis());
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale(this.request));
    }

    @Test
    public void testIsStaleExpiresHeader() {
        Headers headers = this.createDefaultHeaders().add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)this.now));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale(this.request));
    }

    @Test
    public void testIsNotStaleExpiresHeader() {
        Headers headers = this.createDefaultHeaders();
        DateTime future = new DateTime((Object)this.now);
        future = future.plusHours(1);
        headers = headers.add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)future));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was stale", (!this.item.isStale(this.request) ? 1 : 0) != 0);
    }

    @Test
    public void testIsStaleEqualToDateHeader() {
        Headers headers = new Headers();
        DateTime future = new DateTime((Object)this.now);
        future = future.plusHours(1);
        headers = headers.add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)future));
        headers = headers.add(HeaderUtils.toHttpDate((String)"Date", (DateTime)future));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was stale", (boolean)this.item.isStale(this.request));
    }

    public void testIsStaleExpiresHeaderWithInvalidDate() {
        Headers headers = new Headers().add(new Header("Expires", "foo"));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was stale", (boolean)this.item.isStale(this.request));
    }

    @Test
    public void testIsStaleExpiresHeaderWithCacheControl() {
        Headers headers = this.createDefaultHeaders();
        headers = headers.add(new Header("Cache-Control", "private, max-age=60"));
        DateTime future = new DateTime((Object)this.now);
        future = future.plusHours(24);
        headers = headers.add(HeaderUtils.toHttpDate((String)"Expires", (DateTime)future));
        this.setupItem(headers);
        Assert.assertTrue((String)"Item was not stale", (boolean)this.item.isStale(this.request));
    }

    private DateTime createDateTime(int seconds) {
        return this.now.plus((ReadableDuration)Seconds.seconds((int)seconds).toStandardDuration());
    }

    @Test
    public void ageShouldBe10Seconds() {
        Headers headers = new Headers().add(HeaderUtils.toHttpDate((String)"Date", (DateTime)this.createDateTime(0)));
        DateTimeUtils.setCurrentMillisFixed((long)this.createDateTime(10).getMillis());
        HTTPResponse cachedResponse = new HTTPResponse(null, Status.OK, headers);
        int age = new DefaultCacheItem(cachedResponse, this.createDateTime(0)).getAge(new HTTPRequest(URI.create("foo")));
        Assert.assertEquals((long)10L, (long)age);
    }
}

