/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.cache.Vary;
import org.codehaus.httpcache4j.util.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class KeyTest {
    @Test
    public void testSerializationWithEmptyVary() {
        Key key1 = Key.create((URI)URI.create("foo"), (Vary)new Vary());
        byte[] bytes = SerializationUtils.serialize((Serializable)key1);
        Key key2 = (Key)SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals((Object)key1, (Object)key2);
    }

    @Test
    public void testSerializationOneItemInVary() {
        Key key1 = Key.create((URI)URI.create("foo"), (Vary)new Vary(Collections.singletonMap("Accept-Language", "en")));
        byte[] bytes = SerializationUtils.serialize((Serializable)key1);
        Key key2 = (Key)SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals((Object)key1, (Object)key2);
    }

    @Test
    public void keyHasVariation() {
        Key key1 = Key.create((HTTPRequest)new HTTPRequest(URI.create("foo")).addHeader("Accept-Language", "en"), (HTTPResponse)new HTTPResponse(null, Status.OK, new Headers().add("Vary", "Accept-Language")));
        Assert.assertEquals((Object)"en", key1.getVary().getVaryHeaders().get("Accept-Language"));
    }
}

