package org.codehaus.mojo.axistools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on axistools-maven-plugin. Call <pre>  mvn axistools:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Dec 07 00:29:35 CET 2008
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:axistools-maven-plugin:1.2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Axis Tools Plugin 1.2", 0 );
        append( sb, "This plugin supports the wsdl2java and java2wsdl tools from the Apache Axis (1) project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "admin".equals( goal ) )
        {
            append( sb, "axistools:admin", 0 );
            append( sb, "Utility for turning xml into Axis deployment operations (wraps org.apache.axis.utils.Admin)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "configOutputDirectory", 2 );
                append( sb, "Where the server-config.wsdd or client-config.wsdd should go", 3 );
                append( sb, "", 0 );

                append( sb, "inputFiles", 2 );
                append( sb, "Files used to create deployment file", 3 );
                append( sb, "", 0 );

                append( sb, "isServerConfig", 2 );
                append( sb, "Generate a server or client deployment file", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "axistools:help", 0 );
            append( sb, "Display help information on axistools-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0axistools:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "java2wsdl".equals( goal ) )
        {
            append( sb, "axistools:java2wsdl", 0 );
            append( sb, "A Plugin for generating WSDL files using Axis Java2WSDL.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "all", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "bindingName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "classOfPortType", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "classesDirectory", 2 );
                append( sb, "the directory the compile objects will be located for java2wsdl to source from", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "extraClasses", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "filename", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "implClass", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "importSchema", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "input", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "location", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "locationImport", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "methods", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "namespace", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "namespaceImpl", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "outputImpl", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "outputWSDLMode", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageToNamespace", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "portTypeName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "serviceElementName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "servicePortName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "soapAction", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "stopClasses", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "style", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "typeMappingVersion", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "use", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "wsdl2java".equals( goal ) )
        {
            append( sb, "axistools:wsdl2java", 0 );
            append( sb, "A Plugin for generating stubs for WSDL files using Axis WSDL2Java.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allElements", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "debug", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "deployScope", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "factory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "fileNamespaceToPackage", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "helperGen", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "implementationClassName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "mappings", 2 );
                append( sb, "mappings are only used when useEmitter is set to true", 3 );
                append( sb, "", 0 );

                append( sb, "namespaceToPackage", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "noImports", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "noWrapped", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "nsExcludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "nsIncludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageSpace", 2 );
                append( sb, "package to create the java files under", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "runTestCasesAsUnitTests", 2 );
                append( sb, "copy the generated test cases to a generated-sources test directory to be compiled and run as normal surefire unit tests", 3 );
                append( sb, "", 0 );

                append( sb, "serverSide", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "skeletonDeploy", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencies", 2 );
                append( sb, "list of source dependencies in the format groupId:artifactId:version:file", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyDirectory", 2 );
                append( sb, "Cache directory for WSDLs from sourceDependencies", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory", 2 );
                append( sb, "source directory that contains .wsdl files", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation", 3 );
                append( sb, "", 0 );

                append( sb, "subPackageByFileName", 2 );
                append( sb, "load.wsdl would further subpackage into load.*", 3 );
                append( sb, "", 0 );

                append( sb, "testCases", 2 );
                append( sb, "generate the test cases", 3 );
                append( sb, "", 0 );

                append( sb, "testSourceDirectory", 2 );
                append( sb, "location to place generated test source", 3 );
                append( sb, "", 0 );

                append( sb, "timeout", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "timestampDirectory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "typeMappingVersion", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "urlDownloadDirectory", 2 );
                append( sb, "Cache directory for WSDLs from URLs", 3 );
                append( sb, "", 0 );

                append( sb, "urls", 2 );
                append( sb, "list of urls to process", 3 );
                append( sb, "", 0 );

                append( sb, "useEmitter", 2 );
                append( sb, "use the Emitter for generating the java files as opposed to the commandline wsdl2java tool", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "verbose", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "wrapArrays", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "wsdlFiles", 2 );
                append( sb, "List of wsdl files from sourceDirectory to process", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
