/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;

public abstract class AbstractSchemaCassandraMojo
extends AbstractCassandraMojo {
    protected String keyspace;

    protected abstract void executeOperation(Cassandra.Client var1) throws InvalidRequestException, TException;

    protected abstract void parseArguments() throws IllegalArgumentException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.parseArguments();
        }
        catch (IllegalArgumentException iae) {
            throw new MojoExecutionException(iae.getMessage());
        }
        this.executeThrift();
    }

    protected void executeThrift() throws MojoExecutionException, MojoFailureException {
        TSocket socket = new TSocket(this.rpcAddress, this.rpcPort);
        TFramedTransport transport = new TFramedTransport((TTransport)socket);
        TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)transport, true, true);
        Cassandra.Client cassandraClient = new Cassandra.Client((TProtocol)binaryProtocol);
        try {
            transport.open();
            cassandraClient.set_keyspace(this.keyspace);
            this.executeOperation(cassandraClient);
        }
        catch (TTransportException tte) {
            throw new MojoExecutionException("There was a problemn opening the connection to Apache Cassandra", (Exception)((Object)tte));
        }
        catch (InvalidRequestException ire) {
            throw new MojoExecutionException("Invalid request returned. Does the Keyspace '" + this.keyspace + "' exist?", (Exception)((Object)ire));
        }
        catch (Exception e) {
            throw new MojoExecutionException("General exception executing truncate", e);
        }
        finally {
            if (transport != null && transport.isOpen()) {
                try {
                    transport.flush();
                    transport.close();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Something went wrong cleaning up", e);
                }
            }
        }
    }
}

