/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TException;
import org.codehaus.mojo.cassandra.AbstractSchemaCassandraMojo;

public class DropColumnFamiliesMojo
extends AbstractSchemaCassandraMojo {
    protected String columnFamilies;
    private String[] columnFamilyList;

    @Override
    protected void parseArguments() throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)this.keyspace)) {
            throw new IllegalArgumentException("The keyspace to drop column families from cannot be empty");
        }
        this.columnFamilyList = StringUtils.split((String)this.columnFamilies, (char)',');
    }

    @Override
    protected void executeOperation(Cassandra.Client client) throws InvalidRequestException, TException {
        if (this.columnFamilyList != null && this.columnFamilyList.length > 0) {
            for (int i = 0; i < this.columnFamilyList.length; ++i) {
                client.system_drop_column_family(this.columnFamilyList[i]);
                this.getLog().info((CharSequence)("Dropped column family \"" + this.columnFamilyList[i] + "\"."));
            }
        } else {
            client.system_drop_keyspace(this.keyspace);
            this.getLog().info((CharSequence)("Dropped keyspace \"" + this.keyspace + "\"."));
        }
    }
}

