/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:cassandra-maven-plugin:0.7.2-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Mojo's Cassandra Maven Plugin", 0);
        this.append(sb, "The Mojo Projects plugin for Apache Maven to allow launching a local Apache Cassandra instance from a Maven build", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 10 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "cleanup".equals(this.goal)) {
            this.append(sb, "cassandra:cleanup", 0);
            this.append(sb, "Runs nodetool cleanup on a Cassandra instance.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "compact".equals(this.goal)) {
            this.append(sb, "cassandra:compact", 0);
            this.append(sb, "Runs nodetool compact on a Cassandra instance.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "delete".equals(this.goal)) {
            this.append(sb, "cassandra:delete", 0);
            this.append(sb, "Deletes the Cassandra home directory that we create for running Cassandra.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "flush".equals(this.goal)) {
            this.append(sb, "cassandra:flush", 0);
            this.append(sb, "Runs nodetool flush on a Cassandra instance.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "cassandra:help", 0);
            this.append(sb, "Display help information on cassandra-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0cassandra:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "load".equals(this.goal)) {
            this.append(sb, "cassandra:load", 0);
            this.append(sb, "Loads a cassandra-cli bscript into a Cassandra instance.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loadFailureIgnore", 2);
                this.append(sb, "Whether to ignore errors when loading the script.", 3);
                this.append(sb, "Expression: ${cassandra.load.failure.ignore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "script (Default: ${basedir}/src/cassandra/cli/load.script)", 2);
                this.append(sb, "The script to load.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "repair".equals(this.goal)) {
            this.append(sb, "cassandra:repair", 0);
            this.append(sb, "Runs nodetool repair on a Cassandra instance.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "cassandra:run", 0);
            this.append(sb, "Runs Cassandra in the foreground.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loadAfterFirstStart (Default: true)", 2);
                this.append(sb, "When true, if this is a clean start then the load script will be applied automatically.", 3);
                this.append(sb, "Expression: ${cassandra.load.after.first.start}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loadFailureIgnore", 2);
                this.append(sb, "Whether to ignore errors when loading the script.", 3);
                this.append(sb, "Expression: ${cassandra.load.failure.ignore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "script (Default: ${basedir}/src/cassandra/cli/load.script)", 2);
                this.append(sb, "The script to load.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start".equals(this.goal)) {
            this.append(sb, "cassandra:start", 0);
            this.append(sb, "Starts a Cassandra instance in the background.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addMainClasspath (Default: false)", 2);
                this.append(sb, "Adds the main classpath to cassandra (for example you could use this when you have a custom comparator on your main classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "addTestClasspath (Default: false)", 2);
                this.append(sb, "Adds the test classpath to cassandra (for example you could use this when you have a custom comparator on your test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cassandraDir (Default: ${project.build.directory}/cassandra)", 2);
                this.append(sb, "The directory to hold cassandra's database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmxPort (Default: 8080)", 2);
                this.append(sb, "Port to listen to for the JMX interface.", 3);
                this.append(sb, "Expression: ${cassandra.jmxPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loadAfterFirstStart (Default: true)", 2);
                this.append(sb, "When true, if this is a clean start then the load script will be applied automatically.", 3);
                this.append(sb, "Expression: ${cassandra.load.after.first.start}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loadFailureIgnore", 2);
                this.append(sb, "Whether to ignore errors when loading the script.", 3);
                this.append(sb, "Expression: ${cassandra.load.failure.ignore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory (Default: 512)", 2);
                this.append(sb, "Number of megabytes to limit the cassandra JVM to.", 3);
                this.append(sb, "Expression: ${cassandra.maxMemory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "script (Default: ${basedir}/src/cassandra/cli/load.script)", 2);
                this.append(sb, "The script to load.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startWaitSeconds (Default: 180)", 2);
                this.append(sb, "How long to wait for Cassandra to be started before finishing the goal. A value of 0 will wait indefinately. A value of -1 will not wait at all.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to be provided when stopping cassandra", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to listen to for receiving the stop command over", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storagePort (Default: 7000)", 2);
                this.append(sb, "Port to listen to for the Storage interface.", 3);
                this.append(sb, "Expression: ${cassandra.storagePort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.testOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "yaml", 2);
                this.append(sb, "In yaml format any overrides or additional configuration that you want to apply to the server.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "cassandra:stop", 0);
            this.append(sb, "Stops a background Cassandra instance.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "rpcAddress (Default: 127.0.0.1)", 2);
                this.append(sb, "Address to use for the RPC interface. Do not change this unless you really know what you are doing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpcPort (Default: 9160)", 2);
                this.append(sb, "Port to listen to for the RPC interface.", 3);
                this.append(sb, "Expression: ${cassandra.rpcPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "Expression: ${cassandra.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey (Default: cassandra-maven-plugin)", 2);
                this.append(sb, "Key to provide when stopping cassandra", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cassandra.stopKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort (Default: 8081)", 2);
                this.append(sb, "Port to send stop command over", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cassandra.stopPort}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

