/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common.abstractmojo;

import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.jdom.JDOMException;

public abstract class AbstractCheckMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ProjectBaseDir projectBaseDir = new ProjectBaseDir(this.getMavenProject(), this.getLog());
            TestDataDirectory testDataDirectory = projectBaseDir.getDataDirectory(this.getDataId());
            GroupedResponsetimeSamples rtSamples = testDataDirectory.readResponsetimeSamples();
            if (rtSamples.size() == 0) {
                throw new MojoExecutionException("Response time samples not found in " + testDataDirectory.getDirectory());
            }
            long totalTime = rtSamples.getTotalTime();
            this.validateMaxThroughput(rtSamples);
            this.validateFailedSamples(rtSamples);
            this.validateAverageResponsetime(rtSamples);
            this.validatePercentile95Responsetime(rtSamples);
            this.validatePercentile99Responsetime(rtSamples);
            this.validateMaxResponsetime(rtSamples);
            GCSamples gcSamples = testDataDirectory.readGCSamples();
            if (gcSamples != null) {
                this.validateGCTime(gcSamples, totalTime);
                this.validateCollectedPrSecond(gcSamples, totalTime);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure", (Exception)e);
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Failure", (Exception)((Object)e));
        }
    }

    private void validateFailedSamples(ResponsetimeSamples samples) throws MojoExecutionException {
        int failed;
        if (this.getStopOnFailedSamples() && (failed = samples.getFailed()) > 0) {
            throw new MojoExecutionException(failed + " JMeter sample(s) failed");
        }
    }

    private void validateGCTime(GCSamples gcSamples, long totalTime) throws MojoExecutionException {
        if (this.getGcTimeRatio() <= 0.0) {
            return;
        }
        double actualRatio = gcSamples.getGarbageCollectionRatio(totalTime);
        if (actualRatio > this.getGcTimeRatio()) {
            throw new MojoExecutionException("Too much time spent garbagecollection. Ratio of time spent was " + actualRatio + " but acceptable level was " + this.getGcTimeRatio());
        }
    }

    private void validateCollectedPrSecond(GCSamples samples, long totalTime) throws MojoExecutionException {
        if (this.getCollectedPrSecond() <= 0.0) {
            return;
        }
        double actual = samples.getCollectedKBPerSecond(totalTime);
        if (actual > this.getCollectedPrSecond()) {
            throw new MojoExecutionException("To much stuff garbagecollected. Garbagecollected pr second was " + actual + "kb but acceptable level was " + this.getCollectedPrSecond());
        }
    }

    private void validateMaxThroughput(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.getMinThroughput() <= 0.0) {
            return;
        }
        double actual = samples.getMaxAverageThroughput(this.getAverageDuration());
        if (actual < this.getMinThroughput()) {
            throw new MojoExecutionException("Throughput too low. Throughput was " + actual + " but required throughput was " + this.getMinThroughput());
        }
    }

    private void validateAverageResponsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.getResponsetimeAverage() <= 0.0) {
            return;
        }
        this.validateLessThan("Average responsetime too high.", this.getResponsetimeAverage(), samples.getAverage());
    }

    private void validatePercentile95Responsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.getResponsetime95() <= 0.0) {
            return;
        }
        this.validateLessThan("95 percentile responsetime too high.", this.getResponsetime95(), samples.getPercentile95());
    }

    private void validatePercentile99Responsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.getResponsetime99() <= 0.0) {
            return;
        }
        this.validateLessThan("99 percentile responsetime too high.", this.getResponsetime99(), samples.getPercentile99());
    }

    private void validateMaxResponsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.getResponsetimeMax() <= 0.0) {
            return;
        }
        this.validateLessThan("Max responsetime too high.", this.getResponsetimeMax(), samples.getMax());
    }

    private void validateLessThan(String message, double threshold, double measured) throws MojoExecutionException {
        if (measured > threshold) {
            String error = message + " Measured was " + measured + " but acceptable was " + threshold;
            throw new MojoExecutionException(error);
        }
    }

    protected abstract MavenProject getMavenProject();

    protected abstract boolean getStopOnFailedSamples();

    protected abstract String getDataId();

    protected abstract double getCollectedPrSecond();

    protected abstract double getGcTimeRatio();

    protected abstract int getAverageDuration();

    protected abstract double getMinThroughput();

    protected abstract double getResponsetimeAverage();

    protected abstract double getResponsetime95();

    protected abstract double getResponsetime99();

    protected abstract double getResponsetimeMax();
}

