/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class HistoricSample {
    private static final int DEFAULT_DURATION = 20000;
    private long timestamp;
    private double gcRatio = -1.0;
    private double collectedPrSecond = -1.0;
    private double responsetimeAverage = -1.0;
    private double responsetime95Percentile = -1.0;
    private Map<String, Double> individualPercentiles;
    private Map<String, Double> individualAverages;
    private double maxAverageThroughput = -1.0;

    public HistoricSample(GroupedResponsetimeSamples responseSamples, GCSamples gcSamples) {
        this.timestamp = responseSamples.getFirstTimestamp();
        this.responsetimeAverage = responseSamples.getAverage();
        this.responsetime95Percentile = responseSamples.getPercentile95();
        this.individualAverages = new HashMap<String, Double>();
        this.individualPercentiles = new HashMap<String, Double>();
        for (ResponsetimeSampleGroup group : responseSamples.getSampleGroups()) {
            this.individualAverages.put(group.getName(), group.getAverage());
            this.individualPercentiles.put(group.getName(), group.getPercentile95());
        }
        if (gcSamples != null) {
            this.gcRatio = gcSamples.getGarbageCollectionRatio(responseSamples.getTotalTime());
            this.collectedPrSecond = gcSamples.getCollectedKBPerSecond(responseSamples.getTotalTime());
        }
        int averageDuration = Math.max(20000, (int)this.responsetime95Percentile);
        this.maxAverageThroughput = responseSamples.getMaxAverageThroughput(averageDuration);
    }

    private HistoricSample() {
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final double getGcRatio() {
        return this.gcRatio;
    }

    public final double getCollectedPrSecond() {
        return this.collectedPrSecond;
    }

    public final double getResponsetimeAverage() {
        return this.responsetimeAverage;
    }

    public final double getResponsetime95Percentile() {
        return this.responsetime95Percentile;
    }

    public final Set getGroupNames() {
        return this.individualAverages.keySet();
    }

    public final double getResponsetimeAverage(String groupName) {
        return this.individualAverages.get(groupName);
    }

    public final double getResponsetimePercentiles(String groupName) {
        return this.individualPercentiles.get(groupName);
    }

    public final double getMaxAverageThroughput() {
        return this.maxAverageThroughput;
    }

    public final Element toXML() {
        Element historyXML = new Element("history");
        historyXML.setAttribute("timestamp", Long.toString(this.timestamp));
        historyXML.setAttribute("gcRatio", Double.toString(this.gcRatio));
        historyXML.setAttribute("collectedPrSecond", Double.toString(this.collectedPrSecond));
        historyXML.setAttribute("responsetimeAverage", Double.toString(this.responsetimeAverage));
        historyXML.setAttribute("responsetime95Percentile", Double.toString(this.responsetime95Percentile));
        historyXML.setAttribute("maxAverageThroughput", Double.toString(this.maxAverageThroughput));
        Element individualPercentilesXML = new Element("individualPercentiles");
        for (Map.Entry<String, Double> entry : this.individualPercentiles.entrySet()) {
            individualPercentilesXML.addContent((Content)new Element("entry").setAttribute("key", entry.getKey()).setAttribute("value", entry.getValue().toString()));
        }
        historyXML.addContent((Content)individualPercentilesXML);
        Element individualAveragesXML = new Element("individualAverages");
        for (Map.Entry<String, Double> entry : this.individualAverages.entrySet()) {
            individualAveragesXML.addContent((Content)new Element("entry").setAttribute("key", entry.getKey()).setAttribute("value", entry.getValue().toString()));
        }
        historyXML.addContent((Content)individualAveragesXML);
        return historyXML;
    }

    public static HistoricSample fromXML(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        Element historyXML = document.getRootElement();
        if (!"history".equals(historyXML.getName())) {
            throw new JDOMException("Invalid XML structure - history tag expected, but was " + historyXML.getName());
        }
        HistoricSample hs = new HistoricSample();
        hs.timestamp = Long.parseLong(historyXML.getAttributeValue("timestamp"));
        hs.gcRatio = Double.parseDouble(historyXML.getAttributeValue("gcRatio"));
        hs.collectedPrSecond = Double.parseDouble(historyXML.getAttributeValue("collectedPrSecond"));
        hs.responsetimeAverage = Double.parseDouble(historyXML.getAttributeValue("responsetimeAverage"));
        hs.responsetime95Percentile = Double.parseDouble(historyXML.getAttributeValue("responsetime95Percentile"));
        hs.maxAverageThroughput = Double.parseDouble(historyXML.getAttributeValue("maxAverageThroughput"));
        hs.individualPercentiles = HistoricSample.populateMap(historyXML.getChild("individualPercentiles"));
        hs.individualAverages = HistoricSample.populateMap(historyXML.getChild("individualAverages"));
        return hs;
    }

    private static HashMap populateMap(Element xml) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        for (Element entryXML : xml.getChildren()) {
            res.put(entryXML.getAttributeValue("key"), Double.valueOf(entryXML.getAttributeValue("value")));
        }
        return res;
    }
}

