/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.report.chart.DetailsHistogramChartSource;
import org.codehaus.mojo.chronos.report.chart.SummaryHistogramChartSource;

public final class ChronosHistogramPlugin
implements ChronosReportPlugin {
    private ResponsetimeSamples samples;

    public ChronosHistogramPlugin(ResponsetimeSamples samples) {
        this.samples = samples;
    }

    public ChartSource getSummaryChartSource() {
        return new SummaryHistogramChartSource(this.samples);
    }

    public Map getDetailChartSources() {
        LinkedHashMap<String, DetailsHistogramChartSource> testname2ChartSource = new LinkedHashMap<String, DetailsHistogramChartSource>();
        if (!(this.samples instanceof GroupedResponsetimeSamples)) {
            return testname2ChartSource;
        }
        GroupedResponsetimeSamples groupedSamples = (GroupedResponsetimeSamples)this.samples;
        for (ResponsetimeSampleGroup sampleGroup : groupedSamples.getSampleGroups()) {
            testname2ChartSource.put(sampleGroup.getName(), new DetailsHistogramChartSource(sampleGroup));
        }
        return testname2ChartSource;
    }
}

