/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.history;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.chronos.common.HistoricDataDirectory;
import org.codehaus.mojo.chronos.common.model.HistoricSamples;
import org.codehaus.mojo.chronos.report.HistoryReportGenerator;
import org.codehaus.mojo.chronos.report.Utils;
import org.codehaus.mojo.chronos.report.chart.ChartRendererImpl;
import org.codehaus.mojo.chronos.report.chart.HistoryChartGenerator;
import org.jdom.JDOMException;

public class HistoryReportMojo
extends AbstractMavenReport {
    String outputDirectory;
    SiteRenderer siteRenderer;
    MavenProject project;
    String dataid;
    File historydir;
    String title;
    String description;
    private boolean showgc;
    private double historychartupperbound;

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            HistoricDataDirectory dataDirectory = new HistoricDataDirectory(this.historydir, this.dataid);
            HistoricSamples samples = dataDirectory.readHistoricSamples();
            ResourceBundle bundle = Utils.getBundle(locale);
            this.getLog().info((CharSequence)" generating charts...");
            ChartRendererImpl renderer = new ChartRendererImpl(this.getOutputDirectory());
            HistoryChartGenerator charts = new HistoryChartGenerator(renderer, bundle);
            charts.createResponseSummaryChart(samples, this.dataid, this.historychartupperbound);
            charts.createThroughputChart(samples, this.dataid);
            if (this.showgc) {
                charts.createGcChart(samples, this.dataid);
            }
            charts.createResponseDetailsChart(samples, this.dataid);
            HistoryReportGenerator reportgenerator = new HistoryReportGenerator(this.dataid, bundle, this.title, this.description);
            reportgenerator.doGenerateReport(this.getSink(), samples, this.showgc);
        }
        catch (IOException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
        catch (JDOMException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)((Object)e));
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    public String getName(Locale locale) {
        return this.getOutputName();
    }

    public String getOutputName() {
        return "history-" + this.dataid;
    }

    public boolean canGenerateReport() {
        if (!this.historydir.exists()) {
            this.logMissingDir(this.historydir);
            return false;
        }
        File dataDirectory = new File(this.historydir, this.dataid);
        if (!dataDirectory.exists()) {
            this.logMissingDir(dataDirectory);
            return false;
        }
        return true;
    }

    private void logMissingDir(File dir) {
        this.getLog().info((CharSequence)("Directory with historic results " + dir + " not found, skipping historic report."));
    }
}

