package org.codehaus.mojo.cobertura;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on cobertura-maven-plugin.<br/> Call <pre>  mvn cobertura:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon Sep 10 21:49:26 CEST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:cobertura-maven-plugin:2.5.2", 0 );
        append( sb, "", 0 );

        append( sb, "Mojo\'s Maven plugin for Cobertura", 0 );
        append( sb, "This is the Mojo\'s Maven plugin for Cobertura. Cobertura is a free Java tool that calculates the percentage of code accessed by tests. It can be used to identify which parts of your Java program are lacking test coverage.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 6 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "cobertura:check", 0 );
            append( sb, "Check the Last Instrumentation Results.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "forceMojoExecution (Default: false)", 2 );
                append( sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${cobertura.force}", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem (Default: 64m)", 2 );
                append( sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3 );
                append( sb, "Expression: ${cobertura.maxmem}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "Expression: ${quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${cobertura.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "clean".equals( goal ) )
        {
            append( sb, "cobertura:clean", 0 );
            append( sb, "Clean up rogue files that cobertura maven plugin is tracking.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "forceMojoExecution (Default: false)", 2 );
                append( sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${cobertura.force}", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem (Default: 64m)", 2 );
                append( sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3 );
                append( sb, "Expression: ${cobertura.maxmem}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "Expression: ${quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${cobertura.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cobertura".equals( goal ) )
        {
            append( sb, "cobertura:cobertura", 0 );
            append( sb, "Instruments, Tests, and Generates a Cobertura Report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Generate aggregate reports in multi-module projects.", 3 );
                append( sb, "Expression: ${cobertura.aggregate}", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: UTF-8)", 2 );
                append( sb, "The encoding for the java source code files.", 3 );
                append( sb, "Expression: ${project.build.sourceEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "format", 2 );
                append( sb, "The format of the report. (supports \'html\' or \'xml\'. defaults to \'html\')", 3 );
                append( sb, "Expression: ${cobertura.report.format}", 3 );
                append( sb, "", 0 );

                append( sb, "formats", 2 );
                append( sb, "The format of the report. (can be \'html\' and/or \'xml\'. defaults to \'html\')", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass to JVM of Cobertura processes.", 3 );
                append( sb, "Expression: ${cobertura.maxmem}", 3 );
                append( sb, "", 0 );

                append( sb, "omitGplFiles (Default: false)", 2 );
                append( sb, "Whether to remove GPL licensed files from the generated report. This is required to distribute the report as part of a distribution, which is licensed under the ASL, or a similar license, which is incompatible with the GPL.", 3 );
                append( sb, "Expression: ${cobertura.omitGplFiles}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/cobertura)", 2 );
                append( sb, "The output directory for the report.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output cobertura errors, avoid info messages.", 3 );
                append( sb, "Expression: ${quiet}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dump-datafile".equals( goal ) )
        {
            append( sb, "cobertura:dump-datafile", 0 );
            append( sb, "Cobertura Datafile Dump Mojo", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "forceMojoExecution (Default: false)", 2 );
                append( sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${cobertura.force}", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem (Default: 64m)", 2 );
                append( sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3 );
                append( sb, "Expression: ${cobertura.maxmem}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "Expression: ${quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${cobertura.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "cobertura:help", 0 );
            append( sb, "Display help information on cobertura-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0cobertura:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "instrument".equals( goal ) )
        {
            append( sb, "cobertura:instrument", 0 );
            append( sb, "Instrument the compiled classes.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attach (Default: false)", 2 );
                append( sb, "Specifies whether or not to attach the cobertura artifact to the project", 3 );
                append( sb, "Expression: ${cobertura.attach}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier (Default: cobertura)", 2 );
                append( sb, "Specifies the classifier to use for the attached ser artifact", 3 );
                append( sb, "Expression: ${cobertura.classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "forceMojoExecution (Default: false)", 2 );
                append( sb, "Usually most of out cobertura mojos will not get executed on parent poms. Setting this parameter to true will force the execution of this mojo, even if it would usually get skipped in this case.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${cobertura.force}", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "Expression: ${instrumentation}", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem (Default: 64m)", 2 );
                append( sb, "Maximum memory to pass JVM as -Xmx of Cobertura processes.", 3 );
                append( sb, "Expression: ${cobertura.maxmem}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "Expression: ${quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${cobertura.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
