/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jspc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jasper.JspC;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.mojo.jspc.CompilerError;
import org.codehaus.mojo.jspc.JspcMojoClassLoader;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractJspcMojo
extends AbstractMojo {
    private static final String EOL = System.getProperty("line.separator");
    private static final String PS = File.pathSeparator;
    private static final String WARNING_PREFIX = "warning: ";
    private MavenProject project;
    protected String javaEncoding;
    protected String source;
    protected String target;
    protected String workingDirectory;
    protected String webFragmentFile;
    protected String warSourceDirectory;
    protected String inputWebXml;
    protected String injectString;
    protected String outputWebXml;
    protected String packageName;
    protected boolean verbose;
    protected boolean showSuccess;
    protected boolean listErrors;
    protected boolean validateXml;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$PrintWriter;

    protected abstract List getClasspathElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"war".equalsIgnoreCase(this.project.getPackaging())) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Packaging is not war. Plugin irrelevant");
            }
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source directory: " + this.warSourceDirectory));
            this.getLog().debug((CharSequence)("Classpath: " + this.getClasspathElements().toString().replace(',', '\n')));
            this.getLog().debug((CharSequence)("Output directory: " + this.workingDirectory));
        }
        try {
            FileUtils.forceMkdir((File)new File(this.workingDirectory));
            FileUtils.forceMkdir((File)new File(this.webFragmentFile).getParentFile());
            FileUtils.forceMkdir((File)new File(this.outputWebXml).getParentFile());
            FileUtils.forceMkdir((File)new File(this.project.getBuild().getDirectory()));
            FileUtils.forceMkdir((File)new File(this.project.getBuild().getOutputDirectory()));
            String toolsJar = null;
            toolsJar = System.getProperty("os.name").equals("Mac OS X") ? System.getProperty("java.home") + "/../Classes/classes.jar" : System.getProperty("java.home") + File.separatorChar + ".." + File.separatorChar + "lib" + File.separatorChar + "tools.jar";
            List classpathElements = this.getClasspathElements();
            String classPath = this.getPathString(classpathElements);
            ArrayList args = this.getJspcArgs(classPath);
            String[] strArgs = args.toArray(new String[args.size()]);
            ParserUtils.validating = this.validateXml;
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            JspcMojoClassLoader cl = new JspcMojoClassLoader(parent);
            cl.addURL(new File(toolsJar).getAbsoluteFile().toURL());
            Thread.currentThread().setContextClassLoader(cl);
            try {
                JspC jspc = new JspC();
                jspc.setArgs(strArgs);
                jspc.execute();
                String[] sourceFiles = this.getSourceFiles();
                if (sourceFiles.length == 0) {
                    this.getLog().info((CharSequence)"Nothing to compile.");
                } else {
                    this.getLog().info((CharSequence)"Compiling new java files...");
                    Class c = cl.loadClass("com.sun.tools.javac.Main");
                    StringWriter out = new StringWriter();
                    String[] javacArgs = this.getJavacArgs(classPath.toString(), sourceFiles);
                    Method compile = c.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbstractJspcMojo.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = AbstractJspcMojo.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
                    Integer ok = (Integer)compile.invoke(null, javacArgs, new PrintWriter(out));
                    List messages = this.parseModernStream(new BufferedReader(new StringReader(out.toString())));
                    Iterator iter = messages.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (element instanceof String) {
                            this.getLog().info((CharSequence)((String)element));
                            continue;
                        }
                        this.getLog().error((CharSequence)((CompilerError)element).toString());
                    }
                    if (ok != 0) {
                        throw new MojoExecutionException("Errors found during compilation.");
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            this.writeWebXml();
            this.project.addCompileSourceRoot(this.workingDirectory);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private String[] getJavacArgs(String classPath, String[] sourceFiles) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath());
        args.add("-sourcepath");
        args.add(new File(this.workingDirectory).getAbsolutePath());
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.source != null) {
            args.add("-source");
            args.add(this.source);
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.javaEncoding != null) {
            args.add("-encoding");
            args.add(this.javaEncoding);
        }
        args.add("-classpath");
        args.add(classPath);
        for (int i = 0; i < sourceFiles.length; ++i) {
            args.add(sourceFiles[i]);
        }
        this.getLog().debug((CharSequence)("javac args: " + args));
        return args.toArray(new String[args.size()]);
    }

    private ArrayList getJspcArgs(String classPath) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-uriroot");
        args.add(this.warSourceDirectory);
        args.add("-d");
        args.add(this.workingDirectory);
        if (this.javaEncoding != null) {
            args.add("-javaEncoding");
            args.add(this.javaEncoding);
        }
        if (this.source != null) {
            args.add("-source");
            args.add(this.source);
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.showSuccess) {
            args.add("-s");
        }
        if (this.listErrors) {
            args.add("-l");
        }
        args.add("-webinc");
        args.add(this.webFragmentFile);
        args.add("-p");
        args.add(this.packageName);
        if (this.verbose) {
            args.add("-v");
        }
        args.add("-classpath");
        args.add(classPath);
        this.getLog().debug((CharSequence)("jspc args: " + args));
        return args;
    }

    private void writeWebXml() throws Exception {
        String webXml = this.getFile(this.inputWebXml);
        String fragmentXml = this.getFile(this.webFragmentFile);
        int pos = webXml.indexOf(this.injectString);
        if (pos < 0) {
            throw new MojoExecutionException("injectString('" + this.injectString + "') not found in webXml(" + this.inputWebXml + "')");
        }
        String output = webXml.substring(0, pos) + fragmentXml + webXml.substring(pos + this.injectString.length(), webXml.length());
        FileWriter fw = new FileWriter(this.outputWebXml);
        fw.write(output);
        fw.close();
    }

    private String getFile(String fName) throws Exception {
        String line;
        File f = new File(fName);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        fr.close();
        return sb.toString();
    }

    public String getPathString(List pathElements) {
        StringBuffer sb = new StringBuffer();
        Iterator it = pathElements.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(PS);
        }
        return sb.toString();
    }

    protected Set getSourceFilesForSourceRoot() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.workingDirectory);
        scanner.setIncludes(new String[]{"**/*.java"});
        scanner.scan();
        String[] sourceDirectorySources = scanner.getIncludedFiles();
        HashSet<String> sources = new HashSet<String>();
        for (int j = 0; j < sourceDirectorySources.length; ++j) {
            File f = new File(this.workingDirectory, sourceDirectorySources[j]);
            sources.add(f.getPath());
        }
        return sources;
    }

    protected String[] getSourceFiles() {
        HashSet sources = new HashSet();
        sources.addAll(this.getSourceFilesForSourceRoot());
        String[] result = sources.isEmpty() ? new String[]{} : sources.toArray(new String[sources.size()]);
        return result;
    }

    protected List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerError(line, true));
                    continue;
                }
                if (buffer.length() == 0 && line.startsWith("Note: ")) continue;
                buffer.append(line);
                buffer.append(EOL);
            } while (!line.endsWith("^"));
            errors.add(this.parseModernError(buffer.toString()));
        }
    }

    public CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = true;
        try {
            int endcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            StringBuffer msgBuffer = new StringBuffer();
            String msg = tokens.nextToken(EOL).substring(2);
            boolean bl = isError = !msg.startsWith(WARNING_PREFIX);
            if (!isError) {
                msg = msg.substring(WARNING_PREFIX.length());
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(EOL);
                context = tokens.nextToken(EOL);
                try {
                    pointer = tokens.nextToken(EOL);
                }
                catch (NoSuchElementException e) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, isError, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException e) {
            return new CompilerError("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

