/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool.requests;

import java.io.File;
import java.util.Arrays;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolException;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolResult;
import org.codehaus.mojo.keytool.UnsupportedKeyToolRequestException;
import org.codehaus.mojo.keytool.requests.KeyToolRequestFixtures;
import org.codehaus.mojo.keytool.requests.ResourceFixtures;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.cli.Commandline;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyToolRequestIT<R extends KeyToolRequest>
extends PlexusTestCase {
    private static final long BUILD_TIMESTAMP = System.nanoTime();
    protected KeyTool tool;
    protected File workingDirectory;
    protected KeyToolRequestFixtures requestFixtures;
    protected ResourceFixtures resourceFixtures;
    private final boolean supportedRequest;

    protected AbstractKeyToolRequestIT() {
        this(true);
    }

    protected AbstractKeyToolRequestIT(boolean supportedRequest) {
        this.supportedRequest = supportedRequest;
    }

    public abstract void testRequest() throws Exception;

    protected final KeyToolResult consumeRequest(R request) throws KeyToolException {
        KeyToolResult result = null;
        if (this.supportedRequest) {
            result = this.executeKeyToolRequest((KeyToolRequest)request);
        } else {
            this.executeUnsupportedKeyToolRequest((KeyToolRequest)request);
        }
        return result;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        String basedir = AbstractKeyToolRequestIT.getBasedir();
        this.workingDirectory = new File(basedir, "target" + File.separator + "surefire-workdir" + File.separator + ((Object)((Object)this)).getClass().getName() + "_" + BUILD_TIMESTAMP);
        this.tool = (KeyTool)this.lookup(KeyTool.ROLE);
        Assert.assertNotNull((Object)this.tool);
        this.requestFixtures = new KeyToolRequestFixtures();
        this.resourceFixtures = new ResourceFixtures(this.workingDirectory);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.tool = null;
        this.requestFixtures = null;
        this.resourceFixtures = null;
    }

    protected KeyToolResult executeKeyToolRequest(KeyToolRequest request) throws KeyToolException {
        Assert.assertNotNull((Object)request);
        KeyToolResult result = this.tool.execute(request);
        System.out.println(result.getCommandline().toString());
        Assert.assertNotNull((Object)result);
        return result;
    }

    protected void assertKeyToolResult(KeyToolResult result, String[] expectedCommandLineArguments, int expectedExitCode) {
        this.assertKeyToolResult(result, expectedCommandLineArguments);
        AbstractKeyToolRequestIT.assertEquals((String)("Differing exit code , required " + expectedExitCode + " but had : " + result.getExitCode()), (int)expectedExitCode, (int)result.getExitCode());
    }

    protected void assertKeyToolResult(KeyToolResult result, String[] expectedCommandLineArguments) {
        Commandline commandline = result.getCommandline();
        String[] arguments = commandline.getArguments();
        AbstractKeyToolRequestIT.assertEquals((String)("Differing number of arguments, required " + Arrays.asList(expectedCommandLineArguments) + " but had : " + Arrays.asList(arguments)), (int)expectedCommandLineArguments.length, (int)arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            AbstractKeyToolRequestIT.assertEquals((String)expectedCommandLineArguments[i], (String)arguments[i]);
        }
    }

    protected void executeUnsupportedKeyToolRequest(KeyToolRequest request) throws KeyToolException {
        Assert.assertNotNull((Object)request);
        try {
            this.tool.execute(request);
            Assert.fail((String)("Request of type " + request.getClass().getName() + " is not supported."));
        }
        catch (UnsupportedKeyToolRequestException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

