/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool.requests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.junit.Assert;

public class ResourceFixtures {
    protected final File workingDirectory;

    public ResourceFixtures(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public File simpleDestKeyStoreFile(String name) {
        File file = new File(this.workingDirectory, name);
        Assert.assertFalse((boolean)file.exists());
        return file;
    }

    public File simpleDestKeyStoreFile() {
        return this.simpleDestKeyStoreFile("destkeystore");
    }

    public File simpleKeyStore(String name, boolean copy) throws IOException {
        URL keyStoreURL = this.getKeyStoreURL("simple");
        File keyStore = new File(this.workingDirectory, name);
        if (copy) {
            this.copyURLToFile(keyStoreURL, keyStore);
        }
        return keyStore;
    }

    public File simpleKeyStore() throws IOException {
        File keyStore = this.simpleKeyStore(true);
        return keyStore;
    }

    public File simpleKeyStore(boolean copy) throws IOException {
        File keyStore = this.simpleKeyStore("keystore.jks", copy);
        FileUtils.forceMkdir((File)keyStore.getParentFile());
        return keyStore;
    }

    public File simpleKeyStore(String name) throws IOException {
        File keyStore = this.simpleKeyStore(name, true);
        Assert.assertTrue((boolean)keyStore.exists());
        return keyStore;
    }

    public File simpleCertificateRequest() throws IOException {
        URL certificateRequestURL = this.getCertificateRequestURL("simple");
        File inFile = new File(this.workingDirectory, "inFile");
        Assert.assertFalse((boolean)inFile.exists());
        this.copyURLToFile(certificateRequestURL, inFile);
        Assert.assertTrue((boolean)inFile.exists());
        return inFile;
    }

    public File simpleCertificate() throws IOException {
        URL certificateURL = this.getCertificateURL("simple");
        File inFile = new File(this.workingDirectory, "inFile");
        Assert.assertFalse((boolean)inFile.exists());
        this.copyURLToFile(certificateURL, inFile);
        Assert.assertTrue((boolean)inFile.exists());
        return inFile;
    }

    public File outputFile() {
        File outputFile = new File(this.workingDirectory, "outputFile");
        Assert.assertFalse((boolean)outputFile.exists());
        return outputFile;
    }

    protected URL getKeyStoreURL(String prefix) {
        return this.getClass().getResource("/" + prefix + "-keystore");
    }

    protected URL getCertificateRequestURL(String prefix) {
        return this.getClass().getResource("/" + prefix + "-certificate-request");
    }

    protected URL getCertificateURL(String prefix) {
        return this.getClass().getResource("/" + prefix + "-certificate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyURLToFile(URL url, File dest) throws IOException {
        FileUtils.mkdir((String)dest.getParentFile().getAbsolutePath());
        InputStream inputStream = url.openStream();
        try {
            FileOutputStream outputStream = new FileOutputStream(dest);
            try {
                IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                IOUtil.close((OutputStream)outputStream);
            }
        }
        finally {
            IOUtil.close((InputStream)inputStream);
        }
    }
}

