/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;
import org.codehaus.mojo.tools.antcall.AntCallLogger;
import org.codehaus.mojo.tools.antcall.AntCaller;
import org.codehaus.mojo.tools.antcall.AntExecutionException;
import org.codehaus.mojo.tools.antcall.MojoLogAdapter;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.mojo.tools.project.extras.ArtifactPathResolver;
import org.codehaus.mojo.tools.project.extras.DependencyPathResolver;
import org.codehaus.mojo.tools.project.extras.PathResolutionException;
import org.codehaus.mojo.tools.project.extras.PrefixPropertyPathResolver;
import org.codehaus.plexus.context.Context;

public abstract class AbstractMakeExecMojo
extends AbstractMojo {
    private String destDir;
    private MavenProject project;
    private File workDir;
    private Set artifacts;
    private String messageLevel;
    private String command = "make";
    private List options;
    private boolean resolveOptions = true;
    private String target;
    private String checkFile;
    private Properties environment;
    private MavenSession session;
    private List remoteRepositories;
    private List remotePluginRepositories;
    private ArtifactRepository localRepository;
    private MavenProjectBuilder projectBuilder;
    private ArtifactFactory artifactFactory;
    private File executable;
    private boolean searchForExecutable = false;
    private boolean ignoreFailures = false;
    private boolean ignoreErrors = false;
    private boolean chmodUsed = false;
    private boolean skipped = false;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$ExecTask;

    public void execute() throws MojoExecutionException {
        if (this.skipped) {
            this.getLog().info((CharSequence)"Skipping this step of the Make process.");
            return;
        }
        if (BuildAdvisor.isProjectBuildSkipped((MavenProject)this.project, (Context)this.session.getContainer().getContext())) {
            this.getLog().info((CharSequence)"Skipping execution per pre-existing advice.");
            return;
        }
        this.getLog().debug((CharSequence)("In AbstractMakeExecMojo.execute:: workDir= " + this.workDir));
        this.checkSanity();
        this.workDir.mkdirs();
        File check = null;
        long lastMod = 0L;
        if (this.checkFile != null) {
            check = new File(this.checkFile);
            lastMod = check.lastModified();
        }
        AntCaller antCaller = new AntCaller((AntCallLogger)new MojoLogAdapter(this.getLog()));
        if (this.messageLevel != null) {
            antCaller.setMessageLevel(this.messageLevel);
        }
        antCaller.setProjectBasedir(this.workDir);
        if (this.searchForExecutable) {
            this.findExecutable();
        }
        if (this.chmodUsed) {
            this.addChmodTask(antCaller);
        }
        ExecTask exec = new ExecTask();
        exec.setDir(this.workDir);
        exec.setFailIfExecutionFails(!this.ignoreFailures);
        exec.setFailonerror(!this.ignoreErrors);
        String taskName = this.command;
        int lastSlash = taskName.lastIndexOf(File.separator);
        if (lastSlash > -1) {
            taskName = taskName.substring(lastSlash + 1);
        }
        if (this.target != null) {
            taskName = taskName + "->" + this.target;
        }
        exec.setTaskName("exec:" + taskName);
        if (this.executable != null) {
            exec.setExecutable(this.executable.getAbsolutePath());
        } else {
            exec.setExecutable(this.command);
        }
        this.getLog().debug((CharSequence)("Executing command: " + this.command + " in work dir: " + this.workDir));
        ArrayList repos = new ArrayList();
        repos.addAll(this.remoteRepositories);
        repos.addAll(this.remotePluginRepositories);
        PrefixPropertyPathResolver pathResolver = new PrefixPropertyPathResolver(this.projectBuilder, repos, this.localRepository, this.artifactFactory, this.getLog());
        DependencyPathResolver resolver = new DependencyPathResolver((Collection)this.artifacts, (ArtifactPathResolver)pathResolver, this.getLog());
        if (this.options != null) {
            ArrayList<String> resolvedPaths = new ArrayList<String>();
            Iterator it = this.options.iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                if (this.resolveOptions) {
                    try {
                        option = resolver.resolveDependencyPaths(option);
                        resolvedPaths.add(option);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error resolving option: '" + option + "'. Reason: " + e.getMessage(), (Exception)e);
                    }
                    catch (PathResolutionException e) {
                        throw new MojoExecutionException("Error resolving dependency paths for: " + option + ". Reason: " + e.getMessage(), (Exception)((Object)e));
                    }
                }
                exec.createArg().setLine(option);
            }
            this.getLog().debug((CharSequence)(" Resolved ConfigOptions = " + resolvedPaths));
        }
        if (this.environment != null && !((Hashtable)this.environment).isEmpty()) {
            Iterator it = ((Hashtable)this.environment).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                Environment.Variable var = new Environment.Variable();
                var.setKey(key);
                if (this.resolveOptions) {
                    try {
                        val = resolver.resolveDependencyPaths(val);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error resolving environment variable: '" + val + "'. Reason: " + e.getMessage(), (Exception)e);
                    }
                    catch (PathResolutionException e) {
                        throw new MojoExecutionException("Error resolving dependency paths for: " + val + ". Reason: " + e.getMessage(), (Exception)((Object)e));
                    }
                }
                var.setValue(val);
                exec.addEnv(var);
                this.getLog().info((CharSequence)("Setting envar: " + key + "=" + val));
            }
        }
        if (this.target != null && this.target.trim().length() > 0) {
            exec.createArg().setLine(this.target);
        }
        antCaller.addTask((Task)exec);
        try {
            antCaller.executeTasks(this.project);
        }
        catch (AntExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getStackTrace()[0].getClassName().equals((class$org$apache$tools$ant$taskdefs$ExecTask == null ? (class$org$apache$tools$ant$taskdefs$ExecTask = AbstractMakeExecMojo.class$("org.apache.tools.ant.taskdefs.ExecTask")) : class$org$apache$tools$ant$taskdefs$ExecTask).getName())) {
                this.getLog().debug((CharSequence)("Error executing make target. Reason: " + cause.getMessage()), cause);
                throw new MojoExecutionException("Failed to execute make target. Reason: " + cause.getMessage(), cause);
            }
            throw new MojoExecutionException("Failed to execute make target. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        if (check != null && check.lastModified() <= lastMod) {
            throw new MojoExecutionException("Check file: " + check + " not changed.");
        }
    }

    private void checkSanity() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The following usage errors were encountered:\n");
        boolean errorsOccurred = false;
        if (this.command == null) {
            buffer.append("\no Make command cannot be null.");
            errorsOccurred = true;
        }
        if (this.workDir == null) {
            buffer.append("\no working directory cannot be null.");
            errorsOccurred = true;
        }
        if (errorsOccurred) {
            throw new IllegalStateException(buffer.toString());
        }
    }

    protected final boolean isChmodUsed() {
        return this.chmodUsed;
    }

    protected final void setChmodUsed(boolean chmodUsed) {
        this.chmodUsed = chmodUsed;
    }

    protected final String getCheckFile() {
        return this.checkFile;
    }

    protected final void setCheckFile(String checkFile) {
        this.checkFile = checkFile;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final void setCommand(String command) {
        this.command = command;
    }

    protected final List getOptions() {
        return this.options;
    }

    protected final void setOptions(List options) {
        this.options = options;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final void setProject(MavenProject project) {
        this.project = project;
    }

    protected final String getTarget() {
        return this.target;
    }

    protected final void setTarget(String target) {
        this.target = target;
    }

    protected final void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    protected final boolean ignoreFailures() {
        return this.ignoreFailures;
    }

    protected final void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    protected final boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    protected String getDestDir() {
        return this.destDir;
    }

    protected void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    protected File getWorkDir() {
        return this.workDir;
    }

    private void findExecutable() throws MojoExecutionException {
        this.executable = new File(this.command);
        if (!this.executable.exists()) {
            this.getLog().warn((CharSequence)("Cannot find command executable file: '" + this.command + "'. Checking work directory."));
            this.executable = new File(this.workDir, this.command);
            if (!this.executable.exists()) {
                this.executable = null;
                this.getLog().warn((CharSequence)("Cannot find command executable file: '" + this.command + "' in work directory: '" + this.workDir + "'. We will assume this command is on the system path."));
            }
        }
    }

    private void addChmodTask(AntCaller antCaller) {
        if (this.executable != null) {
            ExecTask chmod = new ExecTask();
            chmod.setTaskName("exec:chmod");
            chmod.setExecutable("chmod");
            chmod.createArg().setLine("+x");
            chmod.createArg().setLine(this.executable.getAbsolutePath());
            antCaller.addTask((Task)chmod);
        }
    }

    public final boolean isSkipped() {
        return this.skipped;
    }

    public final void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public final boolean isOptionsResolved() {
        return this.resolveOptions;
    }

    public final void setOptionsResolved(boolean resolveOptions) {
        this.resolveOptions = resolveOptions;
    }

    public boolean isSearchForExecutable() {
        return this.searchForExecutable;
    }

    public void setSearchForExecutable(boolean searchForExecutable) {
        this.searchForExecutable = searchForExecutable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

