/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make.util;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.codehaus.mojo.tools.antcall.AntCallLogger;
import org.codehaus.mojo.tools.antcall.AntCaller;
import org.codehaus.mojo.tools.antcall.AntExecutionException;
import org.codehaus.mojo.tools.antcall.MojoLogAdapter;
import org.codehaus.plexus.util.StringUtils;

public class ChownMojo
extends AbstractMojo {
    private String user;
    private String group;
    private boolean recursive;
    private List chownPaths;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AntCaller antCaller = new AntCaller((AntCallLogger)new MojoLogAdapter(this.getLog()));
        ExecTask chown = new ExecTask();
        chown.setTaskName("exec:chown");
        chown.setExecutable("sudo");
        chown.createArg().setLine("chown");
        if (this.recursive) {
            chown.createArg().setLine("-R");
        }
        String ownership = this.user;
        if (this.group != null) {
            ownership = ownership + ":" + this.group;
        }
        chown.createArg().setLine(ownership);
        String aggregatedPaths = StringUtils.join(this.chownPaths.iterator(), (String)" ");
        chown.createArg().setLine(aggregatedPaths);
        antCaller.addTask((Task)chown);
        try {
            antCaller.executeTasks(this.project);
        }
        catch (AntExecutionException e) {
            throw new MojoExecutionException("Failed to execute chown with ownership: " + ownership + " on files:\n" + this.chownPaths + "\n\nReason: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

